/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/
#include "NewDialog.h"

//(*InternalHeaders(NewDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)

#include <wx/dcmemory.h>
#include <wx/bitmap.h>
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/textfile.h>
#include <wx/image.h>
#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/msgdlg.h>

#if defined(__UNIX__)
    #include <pwd.h>
#endif

//(*IdInit(NewDialog)
const long NewDialog::ID_LISTCTRL1 = wxNewId();
const long NewDialog::ID_STATICLINE2 = wxNewId();
const long NewDialog::ID_LISTCTRL2 = wxNewId();
const long NewDialog::ID_BUTTON3 = wxNewId();
const long NewDialog::ID_STATICTEXT1 = wxNewId();
const long NewDialog::ID_BUTTON2 = wxNewId();
const long NewDialog::ID_BUTTON1 = wxNewId();
const long NewDialog::ID_PANEL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(NewDialog,wxDialog)
	//(*EventTable(NewDialog)
	//*)
END_EVENT_TABLE()

NewDialog::NewDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    CFs_6.DWLog(_T(">>>> Creating dialog\n"));
	//(*Initialize(NewDialog)
	wxBoxSizer* BoxSizer4;
	wxBoxSizer* BoxSizer6;
	wxBoxSizer* BoxSizer5;
	wxBoxSizer* BoxSizer7;
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;
	wxBoxSizer* BoxSizer3;

	Create(parent, wxID_ANY, _("New project"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(400,165));
	BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	Panel1 = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	BoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
	BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	ListCtrl1 = new wxListCtrl(Panel1, ID_LISTCTRL1, wxDefaultPosition, wxSize(155,360), wxLC_ICON|wxLC_ALIGN_TOP|wxLC_AUTOARRANGE|wxVSCROLL, wxDefaultValidator, _T("ID_LISTCTRL1"));
	BoxSizer3->Add(ListCtrl1, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer3, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticLine2 = new wxStaticLine(Panel1, ID_STATICLINE2, wxDefaultPosition, wxSize(0,300), wxLI_VERTICAL, _T("ID_STATICLINE2"));
	BoxSizer2->Add(StaticLine2, 0, wxTOP|wxBOTTOM|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 10);
	BoxSizer4 = new wxBoxSizer(wxVERTICAL);
	ListCtrl2 = new wxListCtrl(Panel1, ID_LISTCTRL2, wxDefaultPosition, wxSize(-1,450), wxLC_ICON|wxLC_SINGLE_SEL, wxDefaultValidator, _T("ID_LISTCTRL2"));
	BoxSizer4->Add(ListCtrl2, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
	BoxSizer7 = new wxBoxSizer(wxHORIZONTAL);
	Button3 = new wxButton(Panel1, ID_BUTTON3, _("About design"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	Button3->Disable();
	BoxSizer7->Add(Button3, 0, wxALL|wxEXPAND|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	StaticText1 = new wxStaticText(Panel1, ID_STATICTEXT1, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	BoxSizer7->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer6->Add(BoxSizer7, 1, wxTOP|wxRIGHT|wxALIGN_LEFT|wxALIGN_BOTTOM, 5);
	BoxSizer5 = new wxBoxSizer(wxHORIZONTAL);
	Button1 = new wxButton(Panel1, ID_BUTTON2, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer5->Add(Button1, 0, wxALL|wxEXPAND|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	Button2 = new wxButton(Panel1, ID_BUTTON1, _("OK"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button2->Disable();
	BoxSizer5->Add(Button2, 0, wxALL|wxEXPAND|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	BoxSizer6->Add(BoxSizer5, 0, wxTOP|wxLEFT|wxALIGN_RIGHT|wxALIGN_BOTTOM, 5);
	BoxSizer4->Add(BoxSizer6, 0, wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer4, 3, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel1->SetSizer(BoxSizer2);
	BoxSizer2->Fit(Panel1);
	BoxSizer2->SetSizeHints(Panel1);
	BoxSizer1->Add(Panel1, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->SetSizeHints(this);
	Center();

	Connect(ID_LISTCTRL1,wxEVT_COMMAND_LIST_ITEM_SELECTED,(wxObjectEventFunction)&NewDialog::OnListCtrl1ItemSelect);
	Connect(ID_LISTCTRL2,wxEVT_COMMAND_LIST_ITEM_SELECTED,(wxObjectEventFunction)&NewDialog::OnListCtrl2ItemSelect);
	Connect(ID_LISTCTRL2,wxEVT_COMMAND_LIST_ITEM_ACTIVATED,(wxObjectEventFunction)&NewDialog::OnListCtrl2ItemActivated);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NewDialog::OnAboutDesign);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NewDialog::OnCancelClick);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NewDialog::OnOKClick);
	//*)

    CFs_6.DWLog(_T(">>>> Loading cases\n"));

#if defined(__UNIX__)
    imageList = new wxImageList(150, 64, true, 3);
    imageList->Add(wxBitmap(wxImage(CFs_6.DataPath()+_T("icons/CD-Standard.png"))), wxNullBitmap);
    imageList->Add(wxBitmap(wxImage(CFs_6.DataPath()+_T("icons/CD-Slim.png"))), wxNullBitmap);
    imageList->Add(wxBitmap(wxImage(CFs_6.DataPath()+_T("icons/DVD-Standard.png"))), wxNullBitmap);
    imageList->Add(wxBitmap(wxImage(CFs_6.DataPath()+_T("icons/DVD-Slim.png"))), wxNullBitmap);
#elif defined(__WXMSW__)
    imageList = new wxImageList(150, 86, true, 3);

    wxMemoryDC memDC;
    wxBitmap bitmap = wxBitmap(150, 86);
    wxBitmap bitmap2;

    memDC.SetBackgroundMode(wxTRANSPARENT);
    memDC.SetBackground(*wxWHITE_BRUSH);

    memDC.SelectObject(bitmap);
    memDC.Clear();
    bitmap2 = wxBitmap(wxImage(CFs_6.DataPath()+_T("icons/CD-Standard.png")));
    memDC.DrawBitmap(bitmap2, 0, (86-bitmap2.GetHeight())/2, 0);
    memDC.SelectObject(wxNullBitmap);
    imageList->Add(bitmap, wxNullBitmap);

    memDC.SelectObject(bitmap);
    memDC.Clear();
    bitmap2 = wxBitmap(wxImage(CFs_6.DataPath()+_T("icons/CD-Slim.png")));
    memDC.DrawBitmap(bitmap2, 0, (86-bitmap2.GetHeight())/2, 0);
    memDC.SelectObject(wxNullBitmap);
    imageList->Add(bitmap, wxNullBitmap);

    memDC.SelectObject(bitmap);
    memDC.Clear();
    bitmap2 = wxBitmap(wxImage(CFs_6.DataPath()+_T("icons/DVD-Standard.png")));
    memDC.DrawBitmap(bitmap2, 0, (86-bitmap2.GetHeight())/2, 0);
    memDC.SelectObject(wxNullBitmap);
    imageList->Add(bitmap, wxNullBitmap);

    memDC.SelectObject(bitmap);
    memDC.Clear();
    bitmap2 = wxBitmap(wxImage(CFs_6.DataPath()+_T("icons/DVD-Slim.png")));
    memDC.DrawBitmap(bitmap2, 0, (86-bitmap2.GetHeight())/2, 0);
    memDC.SelectObject(wxNullBitmap);
    imageList->Add(bitmap, wxNullBitmap);
#endif
    ListCtrl1->SetImageList(imageList, wxIMAGE_LIST_NORMAL);

   /* wxListItem itemCol;
    itemCol.SetText(wxT("Column 1"));
    itemCol.SetImage(-1);
    ListCtrl1->InsertColumn(0, itemCol);
    ListCtrl1->SetColumnWidth(0, wxLIST_AUTOSIZE_USEHEADER );*/

    ListCtrl1->InsertItem(0, wxEmptyString, 0);
    ListCtrl1->InsertItem(1, wxEmptyString, 1);
    ListCtrl1->InsertItem(2, wxEmptyString, 2);
    ListCtrl1->InsertItem(3, wxEmptyString, 3);

    CFs_6.DWLog(_T(">>>> Loading templates/projects"));


    wxString dirp = CFs_6.DataPath()+_T("templates");
    wxDir dir(dirp);

    if ( dir.IsOpened() )
    {
        wxString filename;

        bool cont = dir.GetFirst(&filename, wxEmptyString, wxDIR_FILES);
        while ( cont )
        {
            if ( CFs_6.MyMatches(dirp+_T("/")+filename, _T(".dwtp"), 0, 0) and (CFs_6.MyAfterFirst(filename, _T(".dwtp"), -1, 0, 0) == wxEmptyString) )
                LoadPreTemplate(dirp+_T("/")+filename);

            cont = dir.GetNext(&filename);
        }
    }
    else
    {
        wxMessageDialog(this, _("Unable to open template directory."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();

        CFs_6.DWLog(_T(" Failed\n"));
    }

    dirp = CFs_6.std2wx(CFs_6.oFolder_userM)+CFs_6.PathCoordination+_T("templates");

    if ( wxDir::Exists(dirp) )
    {
        dir.Open(dirp);

        wxString filename;

        bool cont = dir.GetFirst(&filename, wxEmptyString, wxDIR_FILES);
        while ( cont )
        {
            if ( CFs_6.MyMatches(filename, _T(".dwtp"), 0, 0) and (CFs_6.MyAfterFirst(filename, _T(".dwtp"), -1, 0, 0) == wxEmptyString) )
                LoadPreTemplate(dirp+_T("/")+filename);

            cont = dir.GetNext(&filename);
        }
    }
    else
    {
        CFs_6.DWLog(_T("No local template folder\n"));
    }
}

void NewDialog::LoadPreTemplate(wxString filename)
{
    wxTextFile file(filename);

    if ( file.Open() )
    {
        wxString author, contact, license, date, casetype;
        author = contact = license = date = casetype = wxEmptyString;

        wxString line = file.GetFirstLine();
        while ( !file.Eof() )
        {
            line.Trim();
            if ( (line.Len() != 0) and (line[0] != '#') )
            {
                wxString temp = CFs_6.MyAfterFirst(line, _T("CDST="), -1, 0, 0);
                if ( temp != wxEmptyString )
                    casetype += _T("0");

                temp = CFs_6.MyAfterFirst(line, _T("CDSL="), -1, 0, 0);
                if ( temp != wxEmptyString )
                    casetype += _T("1");

                temp = CFs_6.MyAfterFirst(line, _T("DVDST="), -1, 0, 0);
                if ( temp != wxEmptyString )
                    casetype += _T("2");

                temp = CFs_6.MyAfterFirst(line, _T("DVDSL="), -1, 0, 0);
                if ( temp != wxEmptyString )
                    casetype += _T("3");

                temp = CFs_6.MyAfterFirst(line, _T("AUTHOR="), -1, 0, 0);
                if ( temp != wxEmptyString )
                    author = temp;

                temp = CFs_6.MyAfterFirst(line, _T("CONTACT="), -1, 0, 0);
                if ( temp != wxEmptyString )
                    contact = temp;

                temp = CFs_6.MyAfterFirst(line, _T("LICENSE="), -1, 0, 0);
                if ( temp != wxEmptyString )
                    license = temp;

                temp = CFs_6.MyAfterFirst(line, _T("DATE="), -1, 0, 0);
                if ( temp != wxEmptyString )
                    date = temp;
            }

            line = file.GetNextLine();
        }
        file.Close();

        wxString temp2 = filename;
        temp2.RemoveLast();
        temp2.RemoveLast();
        temp2.RemoveLast();
        temp2.RemoveLast();
        temp2.RemoveLast();

        bool valid = true;


        if ( casetype == wxEmptyString )
        {
            valid = false;
            wxMessageDialog(this, _("Type of case is not set or it is invalid:\n")+filename, _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        }

        if ( !wxDir::Exists(temp2) )
        {
            valid = false;
            wxMessageDialog(this, _("Data directory not found for:\n")+filename, _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        }

        if ( valid )
        {
            CCase.Add(casetype);
            Cpath.Add(temp2);
            Cauth.Add(author);
            Ccont.Add(contact);
            Clic.Add(license);
            Cdate.Add(date);
        }

    }
    else
    {
        wxMessageDialog(this, _("Could not open:\n")+filename, _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
    }
}

NewDialog::~NewDialog()
{
	//(*Destroy(NewDialog)
	//*)
}


void NewDialog::OnCancelClick(wxCommandEvent& event)    // close
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_CANCEL); // If modal
        else
        {
             SetReturnCode(wxID_CANCEL);
             this->Show(false); // If modeless
        }
    }
}

void NewDialog::OnListCtrl1ItemSelect(wxListEvent& event)   // list pattern sets by the selected case type
{
    Button2->Disable();
    Button3->Disable();
    if ( ListCtrl2->DeleteAllItems() == false )
    {
        wxMessageDialog(this, _("Unexpected error occured."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        Close();
    }

    wxString casetype = wxEmptyString;
    int CAll = 0;
    if ( ListCtrl1->GetItemState(0, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("0");
    else if ( ListCtrl1->GetItemState(1, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("1");
    else if ( ListCtrl1->GetItemState(2, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("2");
    else if ( ListCtrl1->GetItemState(3, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("3");

    if ( casetype != wxEmptyString )
    {
        int i;
        for ( i = 0 ; i < CCase.GetCount() ; i++ )
            if ( CCase.Item(i).Find(casetype) != wxNOT_FOUND )
                CAll++;

        imageList = new wxImageList(220, 200, true, CAll);

        for ( i = 0 ; i < CAll ; i++ )
        {
            if ( wxFile::Exists(Cpath.Item(i)+_T("/thumbnail.jpg")) )
            {
                wxBitmap jpginput = wxBitmap(wxImage(Cpath.Item(i)+_T("/thumbnail.jpg")));
                if ( (jpginput.GetWidth() == 220) and (jpginput.GetHeight() == 200) )
                    imageList->Add(jpginput, wxNullBitmap);
                else
                    imageList->Add(wxBitmap(wxImage(CFs_6.DataPath()+_T("patterns/wtres.jpg"))), wxNullBitmap);
            }
            else
                imageList->Add(wxBitmap(wxImage(CFs_6.DataPath()+_T("patterns/ntfou.jpg"))), wxNullBitmap);
        }

        ListCtrl2->AssignImageList(imageList, wxIMAGE_LIST_NORMAL);

        for ( i = 0 ; i < CAll; i++ )
            ListCtrl2->InsertItem(i, wxEmptyString, i);

        if ( casetype == _T("0") )
            StaticText1->SetLabel(_("Standard CD case"));
        else if ( casetype == _T("1") )
            StaticText1->SetLabel(_("Slim CD case"));
        else if ( casetype == _T("2") )
            StaticText1->SetLabel(_("Standard DVD case"));
        else if ( casetype == _T("3") )
            StaticText1->SetLabel(_("Slim DVD case"));

    }

}

void NewDialog::OnListCtrl2ItemSelect(wxListEvent& event)   // load data of selected pattern set
{
    Button2->Enable();
    Button3->Enable();


    wxString casetype = wxEmptyString;
    int CAll = 0;
    if ( ListCtrl1->GetItemState(0, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("0");
    else if ( ListCtrl1->GetItemState(1, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("1");
    else if ( ListCtrl1->GetItemState(2, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("2");
    else if ( ListCtrl1->GetItemState(3, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("3");

    if ( casetype != wxEmptyString )
    {
        int i;
        for ( i = 0 ; i < CCase.GetCount() ; i++ )
        {
            if ( CCase.Item(i).Find(casetype) != wxNOT_FOUND )
            {
                if ( ListCtrl2->GetItemState(CAll, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
                {
                    ChosenP = Cpath[i];
                    ChosenC = casetype;
                }
                CAll++;
            }
        }
    }

}

void NewDialog::OnOKClick(wxCommandEvent& event)    // Set data to project and close
{
    On_OK();
}

void NewDialog::On_OK()    // Set data to project and close
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void NewDialog::OnListCtrl2ItemActivated(wxListEvent& event)    // Set data to project and close
{
    On_OK();
}

void NewDialog::OnAboutDesign(wxCommandEvent& event)
{
    wxString casetype = wxEmptyString;
    if ( ListCtrl1->GetItemState(0, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("0");
    else if ( ListCtrl1->GetItemState(1, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("1");
    else if ( ListCtrl1->GetItemState(2, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("2");
    else if ( ListCtrl1->GetItemState(3, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
        casetype = _T("3");

    int i, j;
    for ( i = j = 0 ; i < CCase.GetCount() ; i++ )
    {
        if ( CCase.Item(i).Find(casetype) != wxNOT_FOUND )
        {
            if ( ListCtrl2->GetItemState(j, wxLIST_STATE_SELECTED ) == wxLIST_STATE_SELECTED )
            {
                wxString message = _("Author: ");
                message += Cauth[i];
                message += _("\nContact: ");
                message += Ccont[i];
                message += _("\nLicense: ");
                message += Clic[i];
                message += _("\nDate: ");
                message += Cdate[i];
                wxMessageDialog(this, message, _("Design information"), wxICON_INFORMATION , wxDefaultPosition).ShowModal();
            }
            j++;
        }
    }

}
