/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "ImportTextFileDialog.h"

//(*InternalHeaders(ImportTextFileDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)
#include <wx/msgdlg.h>
#include <wx/textfile.h>

//(*IdInit(ImportTextFileDialog)
const long ImportTextFileDialog::ID_RADIOBOX1 = wxNewId();
const long ImportTextFileDialog::ID_TEXTCTRL1 = wxNewId();
const long ImportTextFileDialog::ID_BUTTON2 = wxNewId();
const long ImportTextFileDialog::ID_BUTTON1 = wxNewId();
const long ImportTextFileDialog::ID_GRID1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(ImportTextFileDialog,wxDialog)
	//(*EventTable(ImportTextFileDialog)
	//*)
END_EVENT_TABLE()

ImportTextFileDialog::ImportTextFileDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(ImportTextFileDialog)
	wxBoxSizer* BoxSizer4;
	wxBoxSizer* BoxSizer6;
	wxBoxSizer* BoxSizer5;
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;
	wxBoxSizer* BoxSizer3;

	Create(parent, wxID_ANY, _("Import properties"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	BoxSizer2 = new wxBoxSizer(wxVERTICAL);
	BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	BoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
	wxString __wxRadioBoxChoices_1[6] =
	{
		_("Tab"),
		_("Comma"),
		_("Semicolon"),
		_("Space"),
		_("Else:"),
		_("No separator")
	};
	RadioBox1 = new wxRadioBox(this, ID_RADIOBOX1, _("Choose separator:"), wxDefaultPosition, wxDefaultSize, 6, __wxRadioBoxChoices_1, 2, wxNO_BORDER, wxDefaultValidator, _T("ID_RADIOBOX1"));
	BoxSizer6->Add(RadioBox1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	TextCtrl1 = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	TextCtrl1->SetMaxLength(1);
	TextCtrl1->Disable();
	BoxSizer6->Add(TextCtrl1, 0, wxTOP|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 23);
	BoxSizer3->Add(BoxSizer6, 1, wxALL|wxSHAPED|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer5 = new wxBoxSizer(wxVERTICAL);
	Button2 = new wxButton(this, ID_BUTTON2, _("Ok"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer5->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(this, ID_BUTTON1, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	BoxSizer5->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3->Add(BoxSizer5, 0, wxALL|wxSHAPED|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer3, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4 = new wxBoxSizer(wxHORIZONTAL);
	Grid1 = new wxGrid(this, ID_GRID1, wxDefaultPosition, wxSize(600,300), wxVSCROLL|wxHSCROLL, _T("ID_GRID1"));
	Grid1->CreateGrid(20,1);
	Grid1->EnableEditing(false);
	Grid1->EnableGridLines(true);
	Grid1->SetColLabelSize(25);
	Grid1->SetRowLabelSize(25);
	Grid1->SetDefaultCellFont( Grid1->GetFont() );
	Grid1->SetDefaultCellTextColour( Grid1->GetForegroundColour() );
	BoxSizer4->Add(Grid1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer4, 1, wxBOTTOM|wxLEFT|wxRIGHT|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer1->Add(BoxSizer2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->Fit(this);
	BoxSizer1->SetSizeHints(this);

	Connect(ID_RADIOBOX1,wxEVT_COMMAND_RADIOBOX_SELECTED,(wxObjectEventFunction)&ImportTextFileDialog::OnRadioBox);
	Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&ImportTextFileDialog::OnText);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ImportTextFileDialog::OnOk);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ImportTextFileDialog::OnCancel);
	Connect(wxID_ANY,wxEVT_INIT_DIALOG,(wxObjectEventFunction)&ImportTextFileDialog::OnInit);
	//*)
}

ImportTextFileDialog::~ImportTextFileDialog()
{
	//(*Destroy(ImportTextFileDialog)
	//*)
}


void ImportTextFileDialog::OnOk(wxCommandEvent& event)
{
    Grid1->ClearGrid();
    if ( Grid1->GetNumberCols() != 0 )
        Grid1->DeleteCols(1, Grid1->GetNumberCols()-1);
    if ( Grid1->GetNumberRows() != 0 )
        Grid1->DeleteRows(0, Grid1->GetNumberRows());


    wxTextFile file(m_path);

    if ( !file.Open() )
    {
        wxMessageDialog(this, _("Unable to open file."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        if ( Validate() && TransferDataFromWindow() )
        {
            if ( IsModal() )
                 EndModal(wxID_CANCEL); // If modal
            else
            {
                 SetReturnCode(wxID_CANCEL);
                 this->Show(false); // If modeless
            }
        }
    }

    int i = 0, j, g;
    wxString line = file.GetFirstLine();
    while ( !file.Eof() )
    {
        Grid1->AppendRows();
        if ( i != 0 )
            line = file.GetNextLine();
        j = 0;
        g = 0;
        while ( j < line.Len() )
        {
            if ( line[j] == Separator )
            {
                if ( Grid1->GetNumberCols() <= ++g )
                    Grid1->AppendCols();
            }
            else
                Grid1->SetCellValue(i, g, Grid1->GetCellValue(i, g)+line[j]);
            j++;
        }
        i++;
    }
    file.Close();

    m_Data.Clear();

    wxString temp = wxEmptyString;
    i = j = 0;

    while ( j < Grid1->GetNumberCols() )
    {
        temp += _T("200;");
        j++;
    }
    temp = wxString::Format(_T("%i"), Grid1->GetNumberCols()) + _T(";") + temp;
    m_Data.Add(temp);

    for ( i = 0 ; i < Grid1->GetNumberRows()-1 ; i++ )
    {
        temp = wxEmptyString;
        for ( j = 0 ; j < Grid1->GetNumberCols() ; j++ )
        {
            int h, v;
            Grid1->GetCellAlignment(i, j, &h, &v);
            if ( h == wxALIGN_LEFT )
                temp += _T("l");
            else if ( h == wxALIGN_CENTRE )
                temp += _T("c");
            else
                temp += _T("r");

            wxString temp2 = Grid1->GetCellValue(i, j);
            temp = temp+wxString::Format(_T("%i"), temp2.Len())+_T(";")+temp2;
        }
        m_Data.Add(temp);
    }


	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void ImportTextFileDialog::OnCancel(wxCommandEvent& event)
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_CANCEL); // If modal
        else
        {
             SetReturnCode(wxID_CANCEL);
             this->Show(false); // If modeless
        }
    }
}

void ImportTextFileDialog::OnRadioBox(wxCommandEvent& event)
{
    TextCtrl1->Enable(false);

    switch(RadioBox1->GetSelection()){
        case 0:
            Separator = _T("\t");
            break;
        case 1:
            Separator = _T(",");
            break;
        case 2:
            Separator = _T(";");
            break;
        case 3:
            Separator = _T(" ");
            break;
        case 4:
            TextCtrl1->Enable(true);
            Separator = TextCtrl1->GetValue();
            break;
        case 5:
            Separator = _T("");
            break;
    }

    RefreshPreview();
}

void ImportTextFileDialog::OnText(wxCommandEvent& event)
{
    Separator = TextCtrl1->GetValue();
    RefreshPreview();
}

void ImportTextFileDialog::RefreshPreview()
{
    Grid1->BeginBatch();
    Grid1->ClearGrid();
    if ( Grid1->GetNumberCols() != 0 )
        Grid1->DeleteCols(1, Grid1->GetNumberCols()-1);


    wxTextFile file(m_path);

    if ( !file.Open() )
    {
        wxMessageDialog(this, _("Unable to open file."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        if ( Validate() && TransferDataFromWindow() )
        {
            if ( IsModal() )
                 EndModal(wxID_CANCEL); // If modal
            else
            {
                 SetReturnCode(wxID_CANCEL);
                 this->Show(false); // If modeless
            }
        }
    }

    int i = 0, j, g;
    wxString line = file.GetFirstLine();
    while ( (i < 20) and (!file.Eof()) )
    {
        if ( i != 0 )
            line = file.GetNextLine();
        j = 0;
        g = 0;
        while ( j < line.Len() )
        {
            if ( line[j] == Separator )
            {
                if ( Grid1->GetNumberCols() <= ++g )
                    Grid1->AppendCols();
            }
            else
                Grid1->SetCellValue(i, g, Grid1->GetCellValue(i, g)+line[j]);
            j++;
        }
        i++;
    }
    file.Close();

	Grid1->AutoSizeColumns();
    Grid1->EndBatch();
}

void ImportTextFileDialog::OnInit(wxInitDialogEvent& event)
{
    Separator = _T("\t");
    RefreshPreview();
}
