/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/
#include "ExportDialog.h"

//(*InternalHeaders(ExportDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)

int Maximum;

//(*IdInit(ExportDialog)
const long ExportDialog::ID_CHOICE1 = wxNewId();
const long ExportDialog::ID_CHOICE2 = wxNewId();
const long ExportDialog::ID_BUTTON1 = wxNewId();
const long ExportDialog::ID_BUTTON2 = wxNewId();
const long ExportDialog::ID_PANEL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(ExportDialog,wxDialog)
	//(*EventTable(ExportDialog)
	//*)
END_EVENT_TABLE()

ExportDialog::ExportDialog(wxWindow* parent,wxWindowID id, int i,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(ExportDialog)
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;
	wxBoxSizer* BoxSizer3;

	Create(parent, wxID_ANY, _("Export"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	Panel1 = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	BoxSizer2 = new wxBoxSizer(wxVERTICAL);
	Choice1 = new wxChoice(Panel1, ID_CHOICE1, wxDefaultPosition, wxDefaultSize, 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	BoxSizer2->Add(Choice1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Choice2 = new wxChoice(Panel1, ID_CHOICE2, wxDefaultPosition, wxDefaultSize, 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE2"));
	Choice2->SetSelection( Choice2->Append(_T("JPEG")) );
	Choice2->Append(_T("PNG"));
	Choice2->Append(_T("BMP"));
	BoxSizer2->Add(Choice2, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	Button1 = new wxButton(Panel1, ID_BUTTON1, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	BoxSizer3->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(Panel1, ID_BUTTON2, _("Export"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer3->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel1->SetSizer(BoxSizer2);
	BoxSizer2->Fit(Panel1);
	BoxSizer2->SetSizeHints(Panel1);
	BoxSizer1->Add(Panel1, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->Fit(this);
	BoxSizer1->SetSizeHints(this);
	Center();

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ExportDialog::OnClose);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ExportDialog::OnExport);
	//*)

	ex_part = ex_format = -2;
	switch(i){
	    case 0:
            Choice1->SetSelection( Choice1->Append(_("Front")) );
            Choice1->Append(_("Front and Inside"));
            Choice1->Append(_("Inside"));
            Choice1->Append(_("Back"));
            Choice1->Append(_("Disc"));
            Maximum = 4;
            break;
	    case 1:
            Choice1->SetSelection( Choice1->Append(_("Front")) );
            Choice1->Append(_("Front and Inside"));
            Choice1->Append(_("Inside"));
            Choice1->Append(_("Disc"));
            Maximum = 3;
            break;
	    case 2:
            Choice1->SetSelection( Choice1->Append(_("Front")) );
            Choice1->Append(_("Disc"));
            Maximum = 1;
            break;
	}

}

ExportDialog::~ExportDialog()
{
	//(*Destroy(ExportDialog)
	//*)
}


void ExportDialog::OnClose(wxCommandEvent& event)
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void ExportDialog::OnExport(wxCommandEvent& event)
{
    ex_part = Choice1->GetCurrentSelection();
    if ( Choice1->GetCurrentSelection() == Maximum )
        ex_part = -3;
    ex_format = Choice2->GetCurrentSelection();
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}
