/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "EditListDialog.h"

//(*InternalHeaders(EditListDialog)
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)
#include <wx/msgdlg.h>

//(*IdInit(EditListDialog)
const long EditListDialog::ID_BITMAPBUTTON1 = wxNewId();
const long EditListDialog::ID_BITMAPBUTTON2 = wxNewId();
const long EditListDialog::ID_BITMAPBUTTON3 = wxNewId();
const long EditListDialog::ID_STATICLINE1 = wxNewId();
const long EditListDialog::ID_GRID1 = wxNewId();
const long EditListDialog::ID_BUTTON1 = wxNewId();
const long EditListDialog::ID_BUTTON2 = wxNewId();
//*)
const long EditListDialog::ID_POPAPPROW = wxNewId();
const long EditListDialog::ID_POPINSERTROW = wxNewId();
const long EditListDialog::ID_POPDELROW = wxNewId();
const long EditListDialog::ID_POPAPPCOL = wxNewId();
const long EditListDialog::ID_POPINSERTCOL = wxNewId();
const long EditListDialog::ID_POPDELCOL = wxNewId();

BEGIN_EVENT_TABLE(EditListDialog,wxDialog)
	//(*EventTable(EditListDialog)
	//*)
END_EVENT_TABLE()

EditListDialog::EditListDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(EditListDialog)
	wxBoxSizer* BoxSizer4;
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;
	wxBoxSizer* BoxSizer3;

	Create(parent, id, _("List editor"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxSize(700,-1));
	Move(wxDefaultPosition);
	BoxSizer1 = new wxBoxSizer(wxVERTICAL);
	BoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
	BoxSizer4 = new wxBoxSizer(wxVERTICAL);
	BitmapButton1 = new wxBitmapButton(this, ID_BITMAPBUTTON1, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/aleft.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON1"));
	BoxSizer4->Add(BitmapButton1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BitmapButton2 = new wxBitmapButton(this, ID_BITMAPBUTTON2, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/acenter.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON2"));
	BitmapButton2->SetDefault();
	BoxSizer4->Add(BitmapButton2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BitmapButton3 = new wxBitmapButton(this, ID_BITMAPBUTTON3, wxBitmap(wxImage(CFs.DataPath()+_T("icons/button/aright.png"))), wxDefaultPosition, wxSize(48,32), wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON3"));
	BitmapButton3->SetDefault();
	BoxSizer4->Add(BitmapButton3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer4, 0, wxTOP|wxBOTTOM|wxALIGN_TOP|wxALIGN_CENTER_HORIZONTAL, 5);
	StaticLine1 = new wxStaticLine(this, ID_STATICLINE1, wxDefaultPosition, wxSize(10,-1), wxLI_VERTICAL, _T("ID_STATICLINE1"));
	BoxSizer2->Add(StaticLine1, 0, wxTOP|wxBOTTOM|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Grid1 = new wxGrid(this, ID_GRID1, wxDefaultPosition, wxSize(500,400), 0, _T("ID_GRID1"));
	BoxSizer2->Add(Grid1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer1->Add(BoxSizer2, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	Button1 = new wxButton(this, ID_BUTTON1, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	BoxSizer3->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Ok"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer3->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer1->Add(BoxSizer3, 0, wxALL|wxSHAPED|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->SetSizeHints(this);

	Connect(ID_BITMAPBUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditListDialog::OnAlign);
	Connect(ID_BITMAPBUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditListDialog::OnAlign);
	Connect(ID_BITMAPBUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditListDialog::OnAlign);
	Connect(ID_GRID1,wxEVT_GRID_LABEL_RIGHT_CLICK,(wxObjectEventFunction)&EditListDialog::OnGrid1LabelRightClick);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditListDialog::OnCancel);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditListDialog::OnOk);
	//*)

    PopRow = new wxMenu();
    PopAppRow = new wxMenuItem(PopRow, ID_POPAPPROW, _("Append row"), _(""), wxITEM_NORMAL);
    PopRow->Append(PopAppRow);
    PopInsertRow = new wxMenuItem(PopRow, ID_POPINSERTROW, _("Insert row"), _(""), wxITEM_NORMAL);
    PopRow->Append(PopInsertRow);
    PopDelRow = new wxMenuItem(PopRow, ID_POPDELROW, _("Delete row"), _(""), wxITEM_NORMAL);
    PopRow->Append(PopDelRow);
    PopCol = new wxMenu();
    PopAppCol = new wxMenuItem(PopCol, ID_POPAPPCOL, _("Append column"), _(""), wxITEM_NORMAL);
    PopCol->Append(PopAppCol);
    PopInsertCol = new wxMenuItem(PopCol, ID_POPINSERTCOL, _("Insert column"), _(""), wxITEM_NORMAL);
    PopCol->Append(PopInsertCol);
    PopDelCol = new wxMenuItem(PopCol, ID_POPDELCOL, _("Delete column"), _(""), wxITEM_NORMAL);
    PopCol->Append(PopDelCol);

    Connect(ID_POPAPPROW,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&EditListDialog::OnAppRow);
    Connect(ID_POPINSERTROW,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&EditListDialog::OnInsRow);
    Connect(ID_POPDELROW,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&EditListDialog::OnDelRow);
    Connect(ID_POPAPPCOL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&EditListDialog::OnAppCol);
    Connect(ID_POPINSERTCOL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&EditListDialog::OnInsCol);
    Connect(ID_POPDELCOL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&EditListDialog::OnDelCol);

    LastR = LastC = -1;
}

EditListDialog::~EditListDialog()
{
	//(*Destroy(EditListDialog)
	//*)
}


void EditListDialog::OnOk(wxCommandEvent& event)
{
    m_DataArray.Clear();

    wxString temp;
    int i = 0, j = 0;

    while ( (i < Header.Len()) and (Header[i] != ';') )
        i++;
    while ( (i < Header.Len()) and (j <= Grid1->GetNumberCols()) )
    {
        temp += Header[i];
        if ( Header[i++] == ';' )
            j++;
    }
    while ( j <= Grid1->GetNumberCols() )
    {
        temp += _T("100;");
        j++;
    }
    temp = wxString::Format(_T("%i"), Grid1->GetNumberCols()) + temp;
    m_DataArray.Add(temp);

    for ( i = 0 ; i < Grid1->GetNumberRows() ; i++ )
    {
        temp = wxEmptyString;
        for ( j = 0 ; j < Grid1->GetNumberCols() ; j++ )
        {
            int h, v;
            Grid1->GetCellAlignment(i, j, &h, &v);
            if ( h == wxALIGN_LEFT )
                temp += _T("l");
            else if ( h == wxALIGN_CENTRE )
                temp += _T("c");
            else
                temp += _T("r");

            wxString temp2 = Grid1->GetCellValue(i, j);
            temp = temp+wxString::Format(_T("%i"), temp2.Len())+_T(";")+temp2;
        }
        m_DataArray.Add(temp);
    }

	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void EditListDialog::OnCancel(wxCommandEvent& event)
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_CANCEL); // If modal
        else
        {
             SetReturnCode(wxID_CANCEL);
             this->Show(false); // If modeless
        }
    }
}

void EditListDialog::SetTableData(int columns, int rows, wxArrayString *data)
{
	Grid1->CreateGrid(rows, columns);
	Grid1->EnableEditing(true);
	Grid1->EnableGridLines(true);
	Grid1->SetColLabelSize(25);
	Grid1->SetRowLabelSize(25);
	Grid1->SetDefaultCellFont( Grid1->GetFont() );
	Grid1->SetDefaultCellTextColour( Grid1->GetForegroundColour() );

    int i, g, k;

    for ( i = 1 ; i < data->GetCount() ; i++ )
    {
        wxChar align;
        long length;
        wxString TempString;

        for ( k = g = 0 ; g < data->Item(i).Len() ; )
        {
            align = data->Item(i)[g++];
            if ( align == 'l' )
                Grid1->SetCellAlignment(wxALIGN_LEFT, i-1, k);
            else if ( align == 'c' )
                Grid1->SetCellAlignment(wxALIGN_CENTRE, i-1, k);
            else
                Grid1->SetCellAlignment(wxALIGN_RIGHT, i-1, k);
            TempString = wxEmptyString;
            while ( data->Item(i)[g] != ';' )
                TempString += data->Item(i)[g++];
            TempString.ToLong(&length);
            TempString = wxEmptyString;
            length += ++g;
            while ( g < length )
                TempString += data->Item(i)[g++];

            Grid1->SetCellValue(i-1, k, TempString);
            k++;
        }
    }

    Header = data->Item(0);

    Grid1->Fit();
}

void EditListDialog::OnGrid1LabelRightClick(wxGridEvent& event)
{
    LastC = event.GetCol();
    LastR = event.GetRow();

    if ( Grid1->GetNumberRows() == 1 )
        PopDelRow->Enable(false);
    else
        PopDelRow->Enable(true);

    if ( Grid1->GetNumberCols() == 1 )
        PopDelCol->Enable(false);
    else
        PopDelCol->Enable(true);

    if ( LastR != -1 )
    {
        PopupMenu(PopRow, wxDefaultPosition);
    }
    else if ( LastC != -1 )
    {
        PopupMenu(PopCol, wxDefaultPosition);
    }
}

void EditListDialog::OnAppRow(wxCommandEvent& event)
{
    if ( !Grid1->AppendRows() )
        wxMessageBox(_("Operation failed somehow."));
}

void EditListDialog::OnInsRow(wxCommandEvent& event)
{
    if ( !Grid1->InsertRows(LastR, 1) )
        wxMessageBox(_("Operation failed somehow."));
}

void EditListDialog::OnDelRow(wxCommandEvent& event)
{
    if ( !Grid1->DeleteRows(LastR, 1) )
        wxMessageBox(_("Operation failed somehow."));
}

void EditListDialog::OnAppCol(wxCommandEvent& event)
{
    if ( !Grid1->AppendCols() )
        wxMessageBox(_("Operation failed somehow."));
}

void EditListDialog::OnDelCol(wxCommandEvent& event)
{
    if ( !Grid1->DeleteCols(LastC, 1) )
        wxMessageBox(_("Operation failed somehow."));
}

void EditListDialog::OnInsCol(wxCommandEvent& event)
{
    if ( !Grid1->InsertCols(LastC, 1) )
        wxMessageBox(_("Operation failed somehow."));
}

void EditListDialog::OnAlign(wxCommandEvent& event)
{
    int align;
    if ( event.GetId() == ID_BITMAPBUTTON1 )
        align = wxALIGN_LEFT;
    else if ( event.GetId() == ID_BITMAPBUTTON2 )
        align = wxALIGN_CENTRE;
    else
        align = wxALIGN_RIGHT;

    wxArrayInt SCols = Grid1->GetSelectedCols();
    wxArrayInt SRows = Grid1->GetSelectedRows();
    wxGridCellCoordsArray SCells = Grid1->GetSelectedCells();
    if ( SCols.GetCount() != 0 )
    {
        int i, j;

        for ( i = 0 ; i < SCols.GetCount() ; i++ )
            for ( j = 0 ; j < Grid1->GetNumberRows() ; j++ )
                Grid1->SetCellAlignment(align, j, SCols.Item(i));
    }
    if ( SRows.GetCount() != 0 )
    {
        int i, j;

        for ( i = 0 ; i < SRows.GetCount() ; i++ )
            for ( j = 0 ; j < Grid1->GetNumberCols() ; j++ )
                Grid1->SetCellAlignment(align, SRows.Item(i), j);
    }
    if ( SCells.GetCount() != 0 )
    {
        int i;

        for ( i = 0 ; i < SRows.GetCount() ; i++ )
            Grid1->SetCellAlignment(align, SCells.Item(i).GetRow(), SCells.Item(i).GetCol());
    }

    if ( (Grid1->GetGridCursorRow() != -1) and (Grid1->GetGridCursorCol() != -1) and (SCols.GetCount() == 0) and (SRows.GetCount() == 0) and (SCells.GetCount() == 0) )
        Grid1->SetCellAlignment(align, Grid1->GetGridCursorRow(), Grid1->GetGridCursorCol());
    Grid1->ForceRefresh();
}
