/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "AboutDialog.h"

//(*InternalHeaders(AboutDialog)
#include <wx/settings.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
//*)

#include <wx/file.h>
#include <wx/bitmap.h>
#include <wx/image.h>
#include <wx/dcclient.h>

//(*IdInit(AboutDialog)
const long AboutDialog::ID_PANEL6 = wxNewId();
const long AboutDialog::ID_STATICTEXT1 = wxNewId();
const long AboutDialog::ID_STATICTEXT2 = wxNewId();
const long AboutDialog::ID_PANEL2 = wxNewId();
const long AboutDialog::ID_TEXTCTRL3 = wxNewId();
const long AboutDialog::ID_PANEL3 = wxNewId();
const long AboutDialog::ID_TEXTCTRL1 = wxNewId();
const long AboutDialog::ID_PANEL4 = wxNewId();
const long AboutDialog::ID_TEXTCTRL2 = wxNewId();
const long AboutDialog::ID_PANEL5 = wxNewId();
const long AboutDialog::ID_NOTEBOOK1 = wxNewId();
const long AboutDialog::ID_BUTTON2 = wxNewId();
const long AboutDialog::ID_PANEL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(AboutDialog,wxDialog)
	//(*EventTable(AboutDialog)
	//*)
END_EVENT_TABLE()

AboutDialog::AboutDialog(wxWindow* parent,wxWindowID id)
{
	//(*Initialize(AboutDialog)
	wxBoxSizer* BoxSizer4;
	wxBoxSizer* BoxSizer6;
	wxBoxSizer* BoxSizer5;
	wxBoxSizer* BoxSizer7;
	wxBoxSizer* BoxSizer8;
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;
	wxBoxSizer* BoxSizer9;
	wxBoxSizer* BoxSizer3;

	Create(parent, wxID_ANY, _("About DiscWrapper"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(-1,-1));
	SetMinSize(wxSize(-1,-1));
	BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	Panel1 = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	BoxSizer2 = new wxBoxSizer(wxVERTICAL);
	Notebook1 = new wxNotebook(Panel1, ID_NOTEBOOK1, wxDefaultPosition, wxDefaultSize, 0, _T("ID_NOTEBOOK1"));
	Panel2 = new wxPanel(Notebook1, ID_PANEL2, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL2"));
	BoxSizer4 = new wxBoxSizer(wxHORIZONTAL);
	BoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
	Panel6 = new wxPanel(Panel2, ID_PANEL6, wxDefaultPosition, wxSize(128,128), wxTAB_TRAVERSAL, _T("ID_PANEL6"));
	BoxSizer6->Add(Panel6, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4->Add(BoxSizer6, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer5 = new wxBoxSizer(wxVERTICAL);
	StaticText1 = new wxStaticText(Panel2, ID_STATICTEXT1, _T("DiscWrapper 1.2.2"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	wxFont StaticText1Font = wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT);
	if ( !StaticText1Font.Ok() ) StaticText1Font = wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT);
	StaticText1Font.SetPointSize((int)(StaticText1Font.GetPointSize() * 2.000000));
	StaticText1Font.SetWeight(wxBOLD);
	StaticText1->SetFont(StaticText1Font);
	BoxSizer5->Add(StaticText1, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(Panel2, ID_STATICTEXT2, _("Cover designer for homemade discs.\n\nCopyright © 2008-2009  Nándor Mátravölgyi\nnmatra@citromail.hu, http://discwrapper.sf.net"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	BoxSizer5->Add(StaticText2, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4->Add(BoxSizer5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel2->SetSizer(BoxSizer4);
	BoxSizer4->Fit(Panel2);
	BoxSizer4->SetSizeHints(Panel2);
	Panel3 = new wxPanel(Notebook1, ID_PANEL3, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL3"));
	BoxSizer9 = new wxBoxSizer(wxHORIZONTAL);
	TextCtrl3 = new wxTextCtrl(Panel3, ID_TEXTCTRL3, _T("Nándor Mátravölgyi"), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL3"));
	BoxSizer9->Add(TextCtrl3, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel3->SetSizer(BoxSizer9);
	BoxSizer9->Fit(Panel3);
	BoxSizer9->SetSizeHints(Panel3);
	Panel4 = new wxPanel(Notebook1, ID_PANEL4, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL4"));
	BoxSizer7 = new wxBoxSizer(wxVERTICAL);
	TextCtrl1 = new wxTextCtrl(Panel4, ID_TEXTCTRL1, _("On behalf of the open source community I would like to thank everyone, who has ever contributed to this software. (also whose names are not here)\n\n"), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	BoxSizer7->Add(TextCtrl1, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel4->SetSizer(BoxSizer7);
	BoxSizer7->Fit(Panel4);
	BoxSizer7->SetSizeHints(Panel4);
	Panel5 = new wxPanel(Notebook1, ID_PANEL5, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL5"));
	BoxSizer8 = new wxBoxSizer(wxHORIZONTAL);
	TextCtrl2 = new wxTextCtrl(Panel5, ID_TEXTCTRL2, wxEmptyString, wxDefaultPosition, wxSize(550,300), wxTE_MULTILINE|wxTE_READONLY|wxTE_DONTWRAP, wxDefaultValidator, _T("ID_TEXTCTRL2"));
	wxFont TextCtrl2Font = wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT);
	if ( !TextCtrl2Font.Ok() ) TextCtrl2Font = wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT);
	TextCtrl2Font.SetPointSize(9);
	TextCtrl2Font.SetStyle(wxFONTSTYLE_NORMAL);
	TextCtrl2Font.SetWeight(wxNORMAL);
	TextCtrl2Font.SetUnderlined(false);
	TextCtrl2Font.SetFaceName(_T("Sans"));
	TextCtrl2->SetFont(TextCtrl2Font);
	BoxSizer8->Add(TextCtrl2, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel5->SetSizer(BoxSizer8);
	BoxSizer8->Fit(Panel5);
	BoxSizer8->SetSizeHints(Panel5);
	Notebook1->AddPage(Panel2, _("About"), false);
	Notebook1->AddPage(Panel3, _("Authors"), false);
	Notebook1->AddPage(Panel4, _("Thanks"), false);
	Notebook1->AddPage(Panel5, _("License"), false);
	BoxSizer2->Add(Notebook1, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	Button2 = new wxButton(Panel1, ID_BUTTON2, _("Close"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer3->Add(Button2, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer3, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxSHAPED|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Panel1->SetSizer(BoxSizer2);
	BoxSizer2->Fit(Panel1);
	BoxSizer2->SetSizeHints(Panel1);
	BoxSizer1->Add(Panel1, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->SetSizeHints(this);
	Center();

	Panel6->Connect(wxEVT_PAINT,(wxObjectEventFunction)&AboutDialog::OnAppIconPaint,0,this);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&AboutDialog::OnCloseClick);
	//*)


    AppIcon = wxBitmap(wxImage(CFs.DataPath()+_T("icons/DW-icon.png")));

    TextCtrl2->LoadFile(CFs.DataPath()+_T("License.txt"));

    TextCtrl1->SetValue(TextCtrl1->GetValue()+_T("Heinrich Schwietering"));
}

AboutDialog::~AboutDialog()
{
	//(*Destroy(AboutDialog)
	//*)
}


void AboutDialog::OnCloseClick(wxCommandEvent& event)
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void AboutDialog::OnAppIconPaint(wxPaintEvent& event)
{
    wxPaintDC dc(Panel6);
    dc.DrawBitmap(AppIcon, 0, 0, 0);
}
