/*
    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "rotate.h"
#include "ui_rotate.h"

Rotate::Rotate(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::Rotate)
{
    ui->setupUi(this);

    loadState();
}

Rotate::~Rotate()
{
    saveState();
    delete ui;
}

QString Rotate::getName(){
    return QString("Rotate");
}

QString Rotate::getTitle(){
    return QString(tr("Rotate"));
}

QString Rotate::getVersion(){
    return QString("0.2");
}

QString Rotate::getAuthor(){
    return QString("FalseCAM");
}

QString Rotate::getDescription(){
    return QString(tr("Plugin to rotate images"));
}

void Rotate::convert(QImage &image, QString &fileName, int index, QString origImage){
    if(!ui->no_rotation->isChecked()){
        //  rotate matrix
        QMatrix m;
        if(ui->clockwise_rotation->isChecked())
            m.rotate( 90.0 );
        if(ui->clockwise180_rotation->isChecked())
            m.rotate( 180.0 );
        if(ui->counter_clockwise_rotation->isChecked())
            m.rotate( 270.0 );
        if(ui->angle_rotation->isChecked())
            m.rotate(ui->degreeBox->value());
        // transform image
        image = image.transformed( m );
    }
}

void Rotate::loadState(){
    QSettings settings(QCoreApplication::organizationName(), QCoreApplication::applicationName());
    settings.beginGroup("plugin");
    ui->degreeBox->setValue(settings.value("Degree", 0).toInt());
}

void Rotate::saveState(){
    QSettings settings(QCoreApplication::organizationName(), QCoreApplication::applicationName());
    settings.beginGroup("plugin");
    settings.beginGroup(QString(getName()));
    settings.setValue("Degree", ui->degreeBox->value());
}
void Rotate::loadTranslation(){
    QString filename;
    filename = QString("lang_" + QLocale::system().name());
    QTranslator *translator = new QTranslator;
    QString translationsDir = QString(":/"+ getName().toLower() +"/languages/");
    translator->load(filename, translationsDir );
    QTranslator *translator2 = new QTranslator;
#if defined(Q_OS_WIN)
    translationsDir = qApp->applicationDirPath() + "/languages/";
#elif defined(Q_OS_LINUX)
    translationsDir = QString("/usr/share/"+qApp->applicationName().toLower()+"/languages/");
#endif
    translationsDir.append(getName().toLower()+"/");
    translator2->load(filename, translationsDir );
    qApp->installTranslator(translator);
    qApp->installTranslator(translator2);
}

Q_EXPORT_PLUGIN2(rotate, Rotate);
