/*
    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "resize.h"
#include "ui_resize.h"

Resize::Resize(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::Resize)
{
    loadTranslation();
    ui->setupUi(this);

    loadState();

    connect(ui->SizePercentRadioButton, SIGNAL(toggled(bool)), this, SLOT(changeSizePercentUse()));
    connect(ui->SizePixelRadioButton, SIGNAL(toggled(bool)), this, SLOT(changeSizePixelUse()));
    connect( ui->PixelComboBox, SIGNAL(activated(QString)), this, SLOT(changeSizePixel()));
    connect( ui->SizeRatioComboBox, SIGNAL(activated(QString)), this, SLOT(changeSizeRatio()));
}

Resize::~Resize()
{
    saveState();
    delete ui;
}

QString Resize::getName(){
    return QString("Resize");
}

QString Resize::getTitle(){
    return QString(tr("Resize"));
}

QString Resize::getVersion(){
    return QString("0.2");
}

QString Resize::getAuthor(){
    return QString("FalseCAM");
}

QString Resize::getDescription(){
    return QString(tr("Plugin to resize images"));
}

void Resize::convert(QImage &image, QString &fileName, int index, QString origImage){
    // scale image by percentage
    if(ui->SizePercentRadioButton->isChecked()){
        image = image.scaled(image.width()*ui->SizeXPercentSpinBox->value()/100,
                             image.height()*ui->SizeYPercentSpinBox->value()/100,
                             Qt::IgnoreAspectRatio );
    }else if(ui->SizePixelRadioButton->isChecked()){
        image = image.scaled(ui->SizeXPixelSpinBox->value(), ui->SizeYPixelSpinBox->value(),
                             Qt::IgnoreAspectRatio);
    }else{}
}

void Resize::changeSizePercentUse(){
    if(ui->SizePercentRadioButton->isChecked()){
        ui->SizeXPercentHorizontalSlider->setEnabled(true);
        ui->SizeXPercentSpinBox->setEnabled(true);
        ui->SizeYPercentHorizontalSlider->setEnabled(true);
        ui->SizeYPercentSpinBox->setEnabled(true);
    }else{
        ui->SizeXPercentHorizontalSlider->setEnabled(false);
        ui->SizeXPercentSpinBox->setEnabled(false);
        ui->SizeYPercentHorizontalSlider->setEnabled(false);
        ui->SizeYPercentSpinBox->setEnabled(false);
    }
}

void Resize::changeSizePixelUse(){
    if(ui->SizePixelRadioButton->isChecked()){
        ui->SizeXPixelSpinBox->setEnabled(true);
        ui->SizeYPixelSpinBox->setEnabled(true);
    }else{
        ui->SizeXPixelSpinBox->setEnabled(false);
        ui->SizeYPixelSpinBox->setEnabled(false);
    }
}

void Resize::changeSizePixel(){
    ui->SizePixelRadioButton->setChecked(true);
    if( ui->PixelComboBox->currentText() == "VGA (640x480)")
    { ui->SizeXPixelSpinBox->setValue(640); ui->SizeYPixelSpinBox->setValue(480);}
    else if( ui->PixelComboBox->currentText() == "XGA (1024x768)")
    {ui->SizeXPixelSpinBox->setValue(1024); ui->SizeYPixelSpinBox->setValue(768);}
    else if( ui->PixelComboBox->currentText() == "NTSC (576x486)")
    {ui->SizeXPixelSpinBox->setValue(576); ui->SizeYPixelSpinBox->setValue(486);}
    else if( ui->PixelComboBox->currentText() == "PAL (720x486)")
    {ui->SizeXPixelSpinBox->setValue(720); ui->SizeYPixelSpinBox->setValue(486);}
    else if( ui->PixelComboBox->currentText() == "HD (1920x1080)")
    {ui->SizeXPixelSpinBox->setValue(1920); ui->SizeYPixelSpinBox->setValue(1080);}
    else if( ui->PixelComboBox->currentText() == "Flickr large (768x1024)")
    {ui->SizeXPixelSpinBox->setValue(768); ui->SizeYPixelSpinBox->setValue(1024);}
    else if( ui->PixelComboBox->currentText() == "iPhone landscape (480x320)")
    {ui->SizeXPixelSpinBox->setValue(480); ui->SizeYPixelSpinBox->setValue(320);}
    else if( ui->PixelComboBox->currentText() == "160x160")
    {ui->SizeXPixelSpinBox->setValue(160); ui->SizeYPixelSpinBox->setValue(160);}
    else if( ui->PixelComboBox->currentText() == "HD 720 (1280x720)")
    {ui->SizeXPixelSpinBox->setValue(1280); ui->SizeYPixelSpinBox->setValue(720);}
    else if( ui->PixelComboBox->currentText() == "SVGA (800x600)")
    {ui->SizeXPixelSpinBox->setValue(800); ui->SizeYPixelSpinBox->setValue(600);}
    else if( ui->PixelComboBox->currentText() =="PSP (480x272)")
    {ui->SizeXPixelSpinBox->setValue(480); ui->SizeYPixelSpinBox->setValue(272);}
    else if( ui->PixelComboBox->currentText() == "2K (2048x1080)")
    {ui->SizeXPixelSpinBox->setValue(2048); ui->SizeYPixelSpinBox->setValue(1080);}
}

void Resize::changeSizeRatio()
{
    ui->SizePercentRadioButton->setChecked(true);
    if( ui->SizeRatioComboBox->currentText() == "1:1")
    { ui->SizeYPercentSpinBox->setValue(ui->SizeXPercentSpinBox->value() * (1.0/1));}
    else if( ui->SizeRatioComboBox->currentText() == "5:4")
    { ui->SizeYPercentSpinBox->setValue(ui->SizeXPercentSpinBox->value() * (4.0/5));}
    else if( ui->SizeRatioComboBox->currentText() == "4:3")
    { ui->SizeYPercentSpinBox->setValue(ui->SizeXPercentSpinBox->value() * (3.0/4));}
    else if( ui->SizeRatioComboBox->currentText() == "16:9")
    { ui->SizeYPercentSpinBox->setValue(ui->SizeXPercentSpinBox->value() * (9.0/16));}
}

void Resize::loadState(){
    QSettings settings(QCoreApplication::organizationName(), QCoreApplication::applicationName());
    settings.beginGroup("plugin");
    settings.beginGroup(QString(getName()));
    ui->SizePixelRadioButton->setChecked(settings.value("PixelUse", false).toBool());
    ui->SizePercentRadioButton->setChecked(settings.value("PercentUse", false).toBool());
    ui->SizeXPixelSpinBox->setValue(settings.value("PixelX", 1920).toInt());
    ui->SizeYPixelSpinBox->setValue(settings.value("PixelY", 1080).toInt());
    ui->SizeXPercentSpinBox->setValue(settings.value("PercentX", 100).toInt());
    ui->SizeXPercentSpinBox->setValue(settings.value("PercentY", 100).toInt());
    changeSizePercentUse();
    changeSizePixelUse();
}

void Resize::saveState(){
    QSettings settings(QCoreApplication::organizationName(), QCoreApplication::applicationName());
    settings.beginGroup("plugin");
    settings.beginGroup(QString(getName()));
    settings.setValue("PixelUse", ui->SizePixelRadioButton->isChecked());
    settings.setValue("PercentUse", ui->SizePercentRadioButton->isChecked());
    settings.setValue("PixelX", ui->SizeXPixelSpinBox->value());
    settings.setValue("PixelY", ui->SizeYPixelSpinBox->value());
    settings.setValue("PercentX", ui->SizeXPercentSpinBox->value());
    settings.setValue("PercentY", ui->SizeYPercentSpinBox->value());
}
void Resize::loadTranslation(){
    QString filename;
    filename = QString("lang_" + QLocale::system().name());
    QTranslator *translator = new QTranslator;
    QString translationsDir = QString(":/"+ getName().toLower() +"/languages/");
    translator->load(filename, translationsDir );
    QTranslator *translator2 = new QTranslator;
#if defined(Q_OS_WIN)
    translationsDir = qApp->applicationDirPath() + "/languages/";
#elif defined(Q_OS_LINUX)
    translationsDir = QString("/usr/share/"+qApp->applicationName().toLower()+"/languages/");
#endif
    translationsDir.append(getName().toLower()+"/");
    translator2->load(filename, translationsDir );
    qApp->installTranslator(translator);
    qApp->installTranslator(translator2);
}

Q_EXPORT_PLUGIN2(resize, Resize);
