#include "pluginsdialog.h"
#include "ui_pluginsdialog.h"
#include <QCheckBox>
#include "imagepluginloader.h"

PluginsDialog::PluginsDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::PluginsDialog)
{
    ui->setupUi(this);
    loadPlugins();
    connect(ui->listWidget, SIGNAL(itemChanged(QListWidgetItem*)), this, SLOT(itemChanged(QListWidgetItem*)));
    connect(ui->upButton, SIGNAL(clicked()), this, SLOT(moveUp()));
    connect(ui->downButton, SIGNAL(clicked()), this, SLOT(moveDown()));

    ui->upButton->setIcon(this->style()->standardIcon(QStyle::SP_ArrowUp));
    ui->downButton->setIcon(this->style()->standardIcon(QStyle::SP_ArrowDown));

    loadConfig();
}

PluginsDialog::~PluginsDialog()
{
    saveConfig();
    delete ui;
}

void PluginsDialog::loadPlugins(){
    foreach(ImagePlugin *plugin, ImagePluginLoader::getInstance().getImagePlugins()){
        QListWidgetItem *listWidgetItem= new QListWidgetItem( plugin->getName() + " " +plugin->getVersion(), ui->listWidget );
        listWidgetItem->setToolTip(
                plugin->getTitle() + " Version " + plugin->getVersion() + " by " + plugin->getAuthor()
                +"<br />"+ plugin->getDescription());
        listWidgetItem->setCheckState( Qt::Unchecked );
    }
}

void PluginsDialog::activatePlugins(QStringList list){
    for( int i = 0; i < ui->listWidget->count(); i++){
        if(list.contains(ui->listWidget->item(i)->text())){
            ui->listWidget->item(i)->setCheckState(Qt::Checked);
        }
    }
}

void PluginsDialog::itemChanged(QListWidgetItem* item){
    if(item->checkState() == Qt::Checked){
        ImagePluginLoader::getInstance().activate(item->text());
    }else{
        ImagePluginLoader::getInstance().deactivate(item->text());
    }
}

void PluginsDialog::moveUp(){
    if(ui->listWidget->currentRow() > 0){
        QListWidgetItem *listWidgetItem = ui->listWidget->takeItem(ui->listWidget->currentRow());
        ui->listWidget->insertItem(ui->listWidget->currentRow()-1, listWidgetItem);
        ui->listWidget->setCurrentRow(ui->listWidget->currentRow()-2);
        setActivated();
    }
}

void PluginsDialog::moveDown(){
    if(ui->listWidget->currentRow() < ui->listWidget->count()){
        QListWidgetItem *listWidgetItem = ui->listWidget->takeItem(ui->listWidget->currentRow());
        ui->listWidget->insertItem(ui->listWidget->currentRow()+1, listWidgetItem);
        ui->listWidget->setCurrentRow(ui->listWidget->currentRow()+1);
        setActivated();
    }
}

void PluginsDialog::setActivated(){
    ImagePluginLoader::getInstance().clearActivated();
    for( int i = 0; i < ui->listWidget->count(); i++){
        itemChanged(ui->listWidget->item(i));
    }
}

void PluginsDialog::loadConfig(){
    QSettings settings(QCoreApplication::organizationName(), QCoreApplication::applicationName());
    settings.beginGroup("plugins");

    QStringList list;
    list = settings.value("ActivatedPlugins", QStringList()).toStringList();
    activatePlugins(list);
}

void PluginsDialog::saveConfig(){
    QSettings settings(QCoreApplication::organizationName(), QCoreApplication::applicationName());
    settings.beginGroup("plugins");

    QStringList stringList; //Temp is the QList<int>
    for( int i = 0; i < ui->listWidget->count(); i++){
        if(ui->listWidget->item(i)->checkState() == Qt::Checked)
            stringList.append(ui->listWidget->item(i)->text());
    }
    QVariant list;
    list.setValue(stringList);
    settings.setValue("ActivatedPlugins", list);
}
