/*
    EasyImageSizer

    Program to resize and rename some image files at the same time.

    Copyright (C) 2010  FalseCAM

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include <QMainWindow>

#include <pluginsdialog.h>
#include "convert.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    // List to store url of images
    QStringList imagesList;
    // QString to store last opened files dir
    QString lastOpenFileDir;
    // Dir where images will be saved
    // Plugins dialog
    PluginsDialog *pluginsDialog;
    // convert class
    Convert *convert;

protected:
    // Drag n Drop
    void dragEnterEvent( QDragEnterEvent* event );
    void dropEvent( QDropEvent* event );

signals:
    void image_list_Changed(int);

public slots:
    // Add Images
    void addImage();
    void addDir();
    void addRDir();
    void addImages(QStringList files);
    void addDir(QString dirString);
    void addRDir(QString dirString);
    bool fileAlreadyAdded(QString file);
    void imageListChanged(int index);
    void clearList();
    void setSaveToDir();
    void startSave();
    void stopSave();
    // Quality Tab
    void changeQualityActivated(int state);

    void changeCopyImagesUse();
    // About boxes
    void showAboutQt();
    void showAbout();
    // show preview
    void changeShowImages();
    // remove Image from List
    void removeImage();
    // state
    void loadState();
    void saveState();
    // Icons for toolbar actions
    void InitIcons();
    // load plugins into widget
    void loadPluginWidgets();
    // Check if exiftool command is available
    void checkForExifTool();
};

#endif // MAINWINDOW_H
