/*
    EasyImageSizer

    Program to resize and rename some image files at the same time.

    Copyright (C) 2010  FalseCAM

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QtGui/QApplication>
#include <QDir>
#include <QTranslator>
#include <QLocale>
#include "mainwindow.h"
#include "imagepluginloader.h"

void loadPlugins(){
    // Loads Plugins in plugins dir
    QDir pluginsDir(QCoreApplication::applicationDirPath());
 #if defined(Q_OS_WIN)
     if (pluginsDir.dirName().toLower() == "debug" || pluginsDir.dirName().toLower() == "release"){
         pluginsDir.cdUp();
         pluginsDir.cdUp();
     }
 #elif defined(Q_OS_MAC)
     if (pluginsDir.dirName() == "MacOS") {
         pluginsDir.cdUp();
         pluginsDir.cdUp();
         pluginsDir.cdUp();
     }
 #endif

     pluginsDir.cd("plugins");
     foreach (QString fileName, pluginsDir.entryList(QDir::Files)) {
         QPluginLoader pluginLoader(pluginsDir.absoluteFilePath(fileName));
         QObject *plugin = pluginLoader.instance();
         if (plugin) {
             // loads Image Plugins
             ImagePlugin *imagePlugin = qobject_cast<ImagePlugin *>(plugin);
             if (imagePlugin){
                 ImagePluginLoader::getInstance().addImagePlugin(imagePlugin);
             }else{
                 delete imagePlugin;
             }
         }
     }
}

void loadTranslation(QApplication *a){
    QString filename;
    filename = QString(qApp->applicationName().toLower() + "_" + QLocale::system().name());
    QTranslator *translator = new QTranslator();
    QString translationsDir;

#if defined(Q_OS_WIN)
    translationsDir = qApp->applicationDirPath() + "/languages/";
#elif defined(Q_OS_LINUX)
    translationsDir = QString("/usr/share/"+qApp->applicationName().toLower()+"/languages/");
#endif

    translator->load(filename, translationsDir );
    qApp->installTranslator(translator);
}

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QCoreApplication::setOrganizationName("FalseCAM");
    QCoreApplication::setApplicationName("EasyImageSizer");
    QCoreApplication::setApplicationVersion("2.1.5");

    loadTranslation(&a);
    loadPlugins();

    MainWindow w;
    w.show();

    return a.exec();
}
