/*
    EasyImageSizer

    Program to resize and rename some image files at the same time.

    Copyright (C) 2010  FalseCAM

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef IMAGEPLUGINLOADER_H
#define IMAGEPLUGINLOADER_H

#include <QObject>
#include <QList>
#include "imageplugin.h"

class ImagePluginLoader : public QObject
   {
    Q_OBJECT
   private:
      static ImagePluginLoader* instance;
      QList<ImagePlugin *> list;
      QList<ImagePlugin *> activatedList;
      ImagePluginLoader(QObject *parent = 0) {}
      ImagePluginLoader(const ImagePluginLoader&) {}
      ~ImagePluginLoader() {}

  signals:
      void pluginStateChanged();
   public:
      static ImagePluginLoader& getInstance();
      void addImagePlugin(ImagePlugin *plugin);
      QList<ImagePlugin *> getImagePlugins();
      QList<ImagePlugin *> getActivatedImagePlugins();
      void clearActivated();
      void activate(QString name);
      void deactivate(QString name);
      static void destroy();
   };
#endif // IMAGEPLUGINLOADER_H
