#include "convert.h"
#include "imagepluginloader.h"

#include <QCoreApplication>
#include <QString>
#include <QDir>
#include <QImage>

Convert::Convert()
{
}

void Convert::run(){
    stop = false;
    for(int i = 0; i<imagesList.count(); i++){
        if(!stop){
            // Processbar to show process state in percent
            emit process(100*(i+1) / imagesList.count());
            save(imagesList.at(i), i);
        }
    }
    emit process(0);
}

// Saves and converts given image
void Convert::save(QString imageFile, int index){
    QString origFileName = imageFile;
    QString tempImage = QDir::tempPath()+ "/" + QCoreApplication::applicationName() + "_tempImage";
    QImage image(imageFile);
    QFileInfo fileInfo(imageFile);
    if(!fileInfo.exists()) return;
    // Save Images into newImages dir if copyImages is chosen
    QString file = fileInfo.completeBaseName();
    QString dir = fileInfo.absolutePath().append("/");
    if( saveTo ){
        if(QDir(saveToDir).exists())
            dir = saveToDir + "/";
        if( copyImage){
            qDebug("%s", qPrintable(QDir(fileInfo.absolutePath()).path()));
            qDebug("%s", qPrintable(QDir(dir).path()));
            if(QDir(fileInfo.absolutePath()).path() == QDir(dir).path())
                dir.append("newImages/");
        }
    }else{
        if( copyImage){
            dir.append("newImages/");
        }
    }

    // convert image
    convertImage(image, file, index, origFileName);

    // Directory of new Image
    if( !QDir(dir).exists() )
        QDir().mkdir( QDir(dir).path() );
    QString destFile = dir.append("/").append(file).append(".").append(imageSaveFormat);

    if(QFileInfo(origFileName).absoluteFilePath() != QFileInfo(destFile).absoluteFilePath()){
        if(QFile(destFile).exists())
            QFile::remove(destFile);
        tempImage = destFile;
    }

    if(changeQuality){
        image.save(tempImage, qPrintable(imageSaveFormat), quality);
    }else{
        image.save(tempImage, qPrintable(imageSaveFormat));
    }

    copyExifData(origFileName, tempImage);

    if(QFileInfo(origFileName).absoluteFilePath() == QFileInfo(destFile).absoluteFilePath())
        QFile::rename(tempImage, destFile);

    emit message(QString(QFileInfo(origFileName).fileName() + " saved as " + destFile), 10000);
}

// converts Image using plugins
void Convert::convertImage(QImage &image, QString &fileName, int index, QString origImage){
    QList<ImagePlugin*> plugins = ImagePluginLoader::getInstance().getActivatedImagePlugins();
    for(int i = 0; i < plugins.count(); i++){
        emit taskProcess(100* (i+1) / plugins.count());
        plugins.at(i)->convert(image, fileName, index, origImage);
    }
    emit taskProcess(0);
}

// Copy exif Data from one file to another
void Convert::copyExifData(QString srcFile, QString destFile){
    // Start new Process that copies exif data
    QProcess process;
    process.start(QString("exiftool -all= -overwrite_original -tagsfromfile \"").append(srcFile)
                  .append("\" -exif:all \"").append(destFile).append("\"").replace("/", QDir::separator()));
    // Wait until process finished
    process.waitForFinished();
}
