/*
 * Copyright (c) 2003 Benedikt Meurer <benedikt.meurer@unix-ag.uni-siegen.de>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * http://www.freedesktop.org/standards/systemtray.html
 */

#ifndef __NETK_TRAY_ICON_H__
#define __NETK_TRAY_ICON_H__

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xmd.h>

#include <gtk/gtk.h>

#define NETK_TYPE_TRAY_ICON     (netk_tray_icon_get_type())
#define NETK_TRAY_ICON(o)       (G_TYPE_CHECK_INSTANCE_CAST((o),        \
                                 NETK_TYPE_TRAY_ICON,                   \
                                 NetkTrayIcon))
#define NETK_TRAY_ICON_CLASS(k) (G_TYPE_CHECK_CLASS_CAST((k),           \
                                 NETK_TYPE_TRAY_ICON,                   \
                                 NetkTrayIconClass))
#define NETK_IS_TRAY_ICON(o)    (G_TYPE_CHECK_INSTANCE_TYPE((o),        \
                                 NETK_TYPE_TRAY_ICON))

G_BEGIN_DECLS 

typedef struct _NetkTrayIcon NetkTrayIcon;
typedef struct _NetkTrayIconClass NetkTrayIconClass;

struct _NetkTrayIcon
{
    /* */
    GtkPlug parent;

    /* atoms */
    struct
    {
        Atom data;
        Atom manager;
        Atom opcode;
        Atom selection;
    }
    atoms;

    /* system tray window */
    Window tray;

    /*
     * "This ID number should never be reused by the same tray icon. (The
     * simplest way to generate the ID number is to increment it with each
     * message sent.)
     */
    glong count;
};

struct _NetkTrayIconClass
{
    GtkPlugClass parent;
};

/* functions */
extern GType netk_tray_icon_get_type (void);
extern GtkWidget *netk_tray_icon_new (Screen *);
extern void netk_tray_icon_set_screen (NetkTrayIcon *, Screen *);
extern glong netk_tray_icon_message_new (NetkTrayIcon *, glong,
                                         const gchar *);
extern void netk_tray_icon_message_cancel (NetkTrayIcon *, glong);

G_END_DECLS
#endif /* !__NETK_TRAY_ICON_H__ */
