// ps fTo sess,pgid,pid,tty,ppid,tpgid,args -C a.out

#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h> // undocumented grantpt,unlockpt,ptsname,openpt,posix_openpt
//#include <pty.h>    // undocumented openpty,forkpty

static pid_t one;

static void die(int signo){
  (void)signo;
  _exit(0);
}

//static void sigchld_handler(int signo){
//  (void)signo;
//  kill(one,SIGHUP);          // kill parent
//}

static void hang(void){
  for(;;) pause();
}

int main(int argc, char *argv[]){
  int master;
  int slave;

  (void)argc;
  (void)argv;

  one = getpid();
  signal(SIGHUP,die);
  if(fork()) hang();    // parent later killed as readyness signal

  // second one exits, to enable setsid(), and the resulting
  // zombie will be reaped by init after 1st process killed
  if(fork()) _exit(0);


  master = open("/dev/ptmx", O_RDWR|O_NOCTTY);

  // could fork, but don't bother
  // (won't be doing anything with the master side)

  // could change child's UID, but don't bother
  // (would make the tests require running as root)

  // not in the man pages!!!
  grantpt(master);
  unlockpt(master);

  if(setsid()==-1){
    kill(one,SIGKILL); // hopefully the shell will complain
    _exit(42); // kind of tough to report errors
  }

  slave = open(ptsname(master), O_RDWR);
#ifdef I_PUSH
  // push STREAMS tty stuff, just to have an example of it
  ioctl(slave, I_PUSH, "ptem");
  ioctl(slave, I_PUSH, "ldterm");
#endif
#ifdef TIOCSCTTY
  // On SysV, slave open got us a TTY. On BSD, we must do this:
  ioctl(fd, TIOCSCTTY, NULL);
#endif


  kill(one,SIGHUP); // let the shell know we're ready

  hang();

  return 0;
}
