# This file gets included into the main Makefile, in the top directory.

#INSTALL += $(bin)test $(man1)test.1 -- some data dump thing maybe?

# directories for cleaning
DIRS += test/ $(wildcard test/*/*/)

TEST_C    := fork-you the_living_dead got-no-tty sidious sid-breaks-ttys \
             gigabyte mini-me funny-thing clone-army clone-once
TESTNAMES := $(addprefix test/,$(TEST_C))
TESTOBJ   := $(addsuffix .o,$(TESTNAMES))
TESTSRC   := $(addsuffix .c,$(TESTNAMES)) test/th.c

# files to create
ALL += $(TESTNAMES)

# files to remove
TEST_JUNK := stderr stdout header stderr.test stderr.good
CLEAN += $(addprefix test/,$(TEST_JUNK)) $(TESTNAMES) test/th $(wildcard test/*.tmp)

TEST_X := module.mk script-child onetest runtests
TARFILES += $(TESTSRC) $(addprefix test/,$(TEST_X)) $(wildcard test/*/*)

$(TESTNAMES): %: %.o
	$(CC) $(ALL_CFLAGS) $(ALL_LDFLAGS) -o $@ $^

# add proc/$(SONAME) on the end later if needed
$(TESTOBJ): %.o: %.c
	$(CC) -c $(ALL_CPPFLAGS) $(ALL_CFLAGS) $< -o $@

test/th: test/th.o
	$(CC) $(ALL_CFLAGS) $(ALL_LDFLAGS) -o $@ $^ -lpthread

test/th.o: test/th.c
	$(CC) -c $(ALL_CPPFLAGS) $(ALL_CFLAGS) $< -o $@

