#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

static void die(int signo){
  (void)signo;
  _exit(0);
}

static void hang(void){
  for(;;) pause();
}

int main(int argc, char *argv[]){
  int fd;
  pid_t pid;

  (void)argc;
  (void)argv;

  pid = getpid();
  signal(SIGHUP,die);
  if(fork()) hang();    // parent later killed as readyness signal


  // Use the TIOCNOTTY ioctl to detach from the tty
  // and, supposedly, set the process group ID to zero.
  // Reality: PGRP unchanged, TPGID becomes -1, TTY lost.
  fd = open("/dev/tty", O_RDONLY);
  if(!fd){
    perror("open /dev/tty");
    _exit(1);
  }
  if(ioctl(fd, TIOCNOTTY)==-1){
    perror("open /dev/tty");
    _exit(1);
  }

  kill(pid,SIGHUP);          // kill parent
  hang();
  return 0;
}
