#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
//#include <sys/ioctl.h>
//#include <sys/stat.h>
//#include <fcntl.h>
#include <stdio.h>
#include <sys/mman.h>

static void die(int signo){
  (void)signo;
  _exit(0);
}

static void hang(void){
  for(;;) pause();
}

#ifndef MAP_NORESERVE
#define MAP_NORESERVE 0
#endif

int main(int argc, char *argv[]){
  void *vp;
  pid_t pid;
  size_t length = 1024*1024*1024;
  unsigned maps;   // how many mappings to do

  (void)argc;
  (void)argv;

  if(sizeof(void*)==8){
    maps = 10;
    puts("64bit");
  }else{
    maps = 1;
    puts("32bit");
  }
  fflush(stdout);

  pid = getpid();
  signal(SIGHUP,die);
  if(fork()) hang();    // parent later killed as readyness signal


  while(maps){
    vp = mmap(
      0,   // start
      length,
      PROT_READ|PROT_WRITE,
      MAP_PRIVATE|MAP_NORESERVE|MAP_ANONYMOUS,
      0,   // fd
      0    // offset
    );
    if(vp==MAP_FAILED){
      // try a smaller size; maybe fragmentation stopped us
      length /= 2;
      maps *= 2;
    }else{
      maps--;
    }
    if(maps>200 || length<2*1024*1024){
      kill(pid,SIGKILL); // hopefully the shell will complain
      _exit(88);
    }
  }

  close(0);
  close(1);
  close(2);
  kill(pid,SIGHUP);          // kill parent
  hang();
  return 0;
}
