#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

static void die(int signo){
  (void)signo;
  _exit(0);
}

static void hang(void){
  for(;;) pause();
}

int main(int argc, char *argv[]){
  pid_t pid;

  (void)argv;

  pid = getpid();
  signal(SIGHUP,die);
  if(fork()) hang();    // parent later killed as readyness signal
  kill(1,9);            // "kill" unkillable init to touch lib pages
  while(argc--) if(!fork()) hang();
  kill(pid,SIGHUP);          // kill parent
  hang();
  return 0;
}
