#if defined(CONFIG_SUPERMOUNT) || defined(CONFIG_SUPERMOUNT_MODULE)

/*
 * These are the "op" operation codes for mediactl() media control
 * calls for device special files
 */
enum {
	MEDIA_LOCK = 1234,	/* Lock the drive door */
	MEDIA_UNLOCK,		/* Unlock the drive door */
	SUPERMOUNT_INC_COUNT,
	SUPERMOUNT_DEC_COUNT,
};

static inline int
supermount_usage_count(struct block_device *bdev, int count)
{
	if (bdev) {
		count -= bdev->bd_disk->scount;
		if (count < 0)
			count = 0;
	}
	return count;
}

static inline int
dev_is_supermounted(struct block_device *bdev)
{
	return bdev ? bdev->bd_disk->scount > 0 : 0;
}

#else /* CONFIG_SUPERMOUNT */

static inline int
supermount_usage_count(struct block_device *bdev, int count)
{
	(void)bdev; // make compiler happy
	return count;
}

static inline int
dev_is_supermounted(struct block_device *bdev)
{
	(void)bdev; // make compiler happy
	return 0;
}

#endif /* CONFIG_SUPERMOUNT */
