/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Amnon Shiloh.
 */
#ifndef _LINUX_REMOTE_FS_I_H
#define _LINUX_REMOTE_FS_I_H
#ifdef CONFIG_MOSIX

struct vm_area_struct;
typedef struct page * (*nopage_t)(struct vm_area_struct *, unsigned long, int);

struct remote_inode_info
{
	int origin;			/* node of origin */
	struct dentry *dp;		/* dentry pointer on origin */
	uint64_t unique;		/* unique version on origin */
	nopage_t nopage;		/* nopage routine */
};

#define	home_file(f)	(*((struct file **)(&(f)->f_pos)))

#endif /* CONFIG_MOSIX */
#endif
