#ifndef _MFS_SOCKET_H
#define _MFS_SOCKET_H

struct socket;

struct mfs_message_header
{
	char version;
	char first;
	short hdsz;
	int caller;
	int serial;
	int type;
	int dat1sz;
	int dat2sz;
};

struct socket *mfs_open_main_socket(void);
struct socket *mfs_new_connection(struct socket *, int *);
struct socket *mfs_connect_to(int);
int mfs_socket_has_data(struct socket *);
int mfs_socket_is_closed(struct socket *);
int mfs_send(struct socket *, int, int, int, void *, int, void *, int, void *, int);
int mfs_receive(struct socket *, int, int *, struct mfs_message_header *, void **, void **, void **);
int mfs_set_main_ownership(struct socket *, int);
void mfs_close_socket(struct socket *);
void mfs_monitor_client_contacts(void);

/* 2nd parameter of mfs_receive: */
enum
{
	MFS_FIRST_RECEIVE,	/* obtain serial */
	MFS_MUST_MATCH,		/* fail if serial does not match */
	MFS_SKIP_OTHERS,	/* skip packet if serial does not match */
	MFS_JUST_HEADER		/* preliminary header check */
};

#define	MFS_MAIN_PORT	0xD302

#endif /* _MFS__SOCKET_H */
