#ifndef _MFS_H
#define _MFS_H

#include <linux/mfs_fs_i.h>

#define	MFS_VERSION	2

#define	MFS_GARBAGE_TIME (2700*HZ)
#define	MFS_REPORT_TIME	(MFS_GARBAGE_TIME/3)

#define	MFS_MAXBLOCK	16384

/* test */

extern int mfs_bh_statfs(mfs_handle_t, struct statfs *);

 struct mfs_server_contact;
struct mfs_client_contact; 

struct mfs_completion
{
	unsigned char needed;
	unsigned char done;
	unsigned char func;
	unsigned char ro;
	int base_pe;
	mfs_handle_t base;
	mfs_handle_t dispose_base;
	int other_pe;
	mfs_handle_t other;
	mfs_handle_t dispose_other;
	union complete_args args;
	void *more_data;
	int more_data_len;
	int error;
};

struct subinode
{
	unsigned long		si_ino;
	unsigned int		si_count;
	umode_t			si_mode;
	nlink_t			si_nlink;
	uid_t			si_iuid;
	gid_t			si_gid;
	kdev_t			si_rdev;
	loff_t			si_size;
	time_t			si_atime;
	time_t			si_mtime;
	time_t			si_ctime;
	unsigned long		si_blksize;
	unsigned long		si_blocks;
	unsigned long		si_origino;
	kdev_t			si_origdev;
};

struct mfs_dinfo
{
	int pe;
	mfs_handle_t handle;
	unsigned long latest;
};

extern int init_mfs(void);
extern void mfs_change_pe(void);
extern void mfs_change_root(struct dentry *, struct vfsmount *, struct dentry *, struct vfsmount *);
extern int is_mfs_root(struct nameidata *);
extern int mfs_walk_init_root(struct nameidata *);
extern void mfs_ip_to_subip(struct subinode *, struct inode *);
extern void mfs_subip_to_ip(struct inode *, struct subinode *);
extern int mfs_conversion_init(void);
extern mfs_handle_t local_to_mfs(struct nameidata *);
extern int mfs_to_local(mfs_handle_t, struct nameidata *);
extern int mfs_get_handle(mfs_handle_t handle);
extern void mfs_put_handle(mfs_handle_t handle);
extern int mfs_access_handle(mfs_handle_t handle);
extern void mfs_lput(struct dentry *, struct vfsmount *);
extern int mfs_try_to_cleanup(int);
extern int mfs_attach_handle(int, mfs_handle_t);
extern void mfs_dispose_handle(int, mfs_handle_t);
extern int mfs_touch_handle(int, mfs_handle_t);
extern ino_t global_inum(struct inode *);
extern void cp_file_fields(struct file *, struct file *);

extern loff_t mfs_low_llseek(mfs_handle_t, struct file *, loff_t, int);
extern ssize_t mfs_low_read(mfs_handle_t, struct file *, char *, size_t, loff_t *);
extern ssize_t mfs_low_write(mfs_handle_t, struct file *, char *, size_t, loff_t *, long);
extern int mfs_low_readdir(mfs_handle_t, struct file *, void *, filldir_t, int *, int *);
extern int mfs_low_ioctl(mfs_handle_t, struct file *, unsigned int, unsigned long, int, int *);
extern int mfs_low_open(mfs_handle_t, struct file *);
extern int mfs_low_fsync(mfs_handle_t, struct file *, int);
extern int mfs_low_attach_handle(mfs_handle_t);
extern int mfs_low_touch_handle(mfs_handle_t);
extern void mfs_low_dispose_handle(mfs_handle_t);
extern int mfs_low_revalidate(mfs_handle_t, struct subinode *);
extern int mfs_low_express_lookup(mfs_handle_t *, char *, unsigned int, int, int, struct subinode *, char **, struct mfs_completion *);
extern int mfs_low_setattr(mfs_handle_t, struct iattr *);
extern char *mfs_low_check_path(mfs_handle_t);

extern void mfs_prepare_completion(struct mfs_completion *, struct nameidata *);
extern int mfs_check_completion(struct mfs_completion *, struct nameidata *);
extern mfs_handle_t mfs_low_complete(struct mfs_completion *, struct nameidata *);
extern void mfs_low_complete_error(struct mfs_completion *, int);
extern int mfs_link_complete(struct mfs_completion *, int, struct nameidata *);

extern struct dentry *mfs_root;
extern struct vfsmount *mfs_mnt;
extern ino_t mfs_root_ino;
extern dev_t mfs_root_dev;
extern struct super_block *mfs_super;
extern int MFS_PE;
extern int mfs_debug;
extern char mfs_is_ro;
#ifdef CONFIG_MOSIX_DFSA
extern char mfs_is_dfsa;
#endif /* CONFIG_MOSIX_DFSA */

#define	MFS_SUPER_MAGIC	235466776
#define	MFS_BAD_PE	65536
#define	MFS_UNKNOWN_PE	65537
#define	MFS_ROOT_INO	65538

/* protocols: */

enum
{
	MFS_NONE = 0,
	MFS_CLOSE,
	MFS_CONTINUE,
	MFS_STOP,
	MFS_INTERIM_DATA,
	MFS_REQUEST_LLSEEK,
	MFS_REPLY_LLSEEK,
	MFS_REQUEST_READ,
	MFS_REPLY_READ,
	MFS_REQUEST_WRITE,
	MFS_REPLY_WRITE,
	MFS_REQUEST_READDIR,
	MFS_INTERIM_READDIR,
	MFS_REPLY_READDIR,
	MFS_REQUEST_IOCTL,
	MFS_REPLY_IOCTL,
	MFS_REQUEST_FSYNC,
	MFS_REPLY_FSYNC,
	MFS_REQUEST_REVALIDATE,
	MFS_REPLY_REVALIDATE,
	MFS_REQUEST_EXPRESS,
	MFS_REPLY_EXPRESS,
	MFS_REQUEST_CHECKPATH,
	MFS_REPLY_CHECKPATH,
	MFS_REQUEST_SETATTR,
	MFS_REPLY_SETATTR,
	MFS_REQUEST_ATTACH_HANDLE,
	MFS_REPLY_ATTACH_HANDLE,
	MFS_REQUEST_TOUCH_HANDLE,
	MFS_REPLY_TOUCH_HANDLE,
	MFS_REQUEST_DISPOSE_HANDLE,
	MFS_REQUEST_STATFS,
	MFS_REPLY_STATFS,
};
struct mfs_cred
{
	        uid_t uid, euid, suid, fsuid;
	        gid_t gid, egid, sgid, fsgid;
	        int ngroups;
	        gid_t groups[NGROUPS];
	        kernel_cap_t caps;
	        int whereami;
	        int deppe;
};
struct mfs_request_statfs
{
	        struct mfs_cred cred;
	        mfs_handle_t handle;
};

struct mfs_reply_statfs
{
	        struct statfs stat;
	        loff_t result;
};
struct mfs_request_llseek
{
	struct mfs_cred cred;
	mfs_handle_t handle;
	struct file file;
	loff_t offset;
	int origin;
};


struct mfs_reply_llseek
{
	struct file file;
	int result;
};

struct mfs_request_read
{
	struct mfs_cred cred;
	mfs_handle_t handle;
	struct file file;
	size_t count;
	loff_t pos;
};

struct mfs_interim_data
{
	size_t count;
};

struct mfs_reply_read
{
	struct file file;
	loff_t ppos;
	ssize_t result;
	size_t datalen;
};

struct mfs_request_write
{
	struct mfs_cred cred;
	mfs_handle_t handle;
	struct file file;
	size_t count;
	loff_t pos;
	size_t datalen;
	long flim;
};

struct mfs_reply_write
{
	struct file file;
	loff_t ppos;
	ssize_t result;
	int hadsigxfsz;
};

struct mfs_request_readdir
{
	struct mfs_cred cred;
	mfs_handle_t handle;
	struct file file;
	int policy;
	int maxbytes;
};

#define	MFS_READDIR_UNKNOWN	0
#define	MFS_READDIR_JUSTONE	1
#define	MFS_READDIR_GETDENTS	2
#define	MFS_READDIR_GETDENTS64	3

struct mfs_interim_readdir
{
	int error;
};

struct mfs_reply_readdir
{
	struct file file;
	int result;
	int datalen;
};

struct mfs_request_ioctl
{
	struct mfs_cred cred;
	mfs_handle_t handle;
	struct file file;
	unsigned int cmd;
	unsigned long arg;
	int data;
	int size;
};

struct mfs_reply_ioctl
{
	struct file file;
	int data;
	int result;
};

struct mfs_request_open
{
	struct mfs_cred cred;
	mfs_handle_t handle;
	struct file file;
};

struct mfs_reply_open
{
	struct file file;
	int result;
};

struct mfs_request_fsync
{
	struct mfs_cred cred;
	mfs_handle_t handle;
	struct file file;
	int datasync;
};

struct mfs_reply_fsync
{
	struct file file;
	int result;
};

struct mfs_request_revalidate
{
	struct mfs_cred cred;
	mfs_handle_t handle;
};

struct mfs_reply_revalidate
{
	struct subinode iinfo;
	int result;
};

struct mfs_request_express
{
	struct mfs_cred cred;
	mfs_handle_t handle;
	int namelen;
	unsigned int follow;
	int link_count;
	int total_link_count;
	struct mfs_completion complete;
};

struct mfs_reply_express
{
	mfs_handle_t handle;
	struct subinode iinfo;
	int namelen;
	struct mfs_completion complete;
	int result;
};

struct mfs_request_checkpath
{
	struct mfs_cred cred;
	mfs_handle_t handle;
};

struct mfs_reply_checkpath
{
	int namelen;
};

struct mfs_request_setattr
{
	struct mfs_cred cred;
	mfs_handle_t handle;
	struct iattr attr;
};

struct mfs_reply_setattr
{
	int result;
};

struct mfs_request_attach_handle
{
	mfs_handle_t handle;
};

struct mfs_reply_attach_handle
{
	int result;
};

struct mfs_request_touch_handle
{
	mfs_handle_t handle;
};

struct mfs_reply_touch_handle
{
	int result;
};

struct mfs_request_dispose_handle
{
	mfs_handle_t handle;
};

struct mfs_server_contact *mfs_alloc_service(void);
void mfs_release_contact(struct mfs_client_contact *);
int mfs_client_contact_has_data(struct mfs_client_contact *);
void mfs_end_serve(struct mfs_server_contact *);
int mfs_server_send(struct mfs_server_contact *, int, void *, int, void *, int, void *, int);
int mfs_client_send(struct mfs_client_contact *, int, void *, int, void *, int, void *, int);
int mfs_server_receive(struct mfs_server_contact *, void **, void **, void **);
int mfs_client_receive(struct mfs_client_contact *, void **, void **, void **);
struct mfs_client_contact *mfs_new_request(int, int, void *, int, void *, int, void *, int);
void mfs_make_servers(void);
void mfs_new_request_arrived(void);
void mfs_serve(struct mfs_server_contact *, int, void *, void *, void *);

int mfs_client_attach_handle(int, mfs_handle_t);
void mfs_client_dispose_handle(int, mfs_handle_t);
int mfs_client_touch_handle(int, mfs_handle_t);
int mfs_client_llseek(int, mfs_handle_t, struct file *, loff_t, int);
ssize_t mfs_client_read(int, mfs_handle_t, struct file *, char *, size_t, loff_t *);
ssize_t mfs_client_write(int, mfs_handle_t, struct file *, char *, size_t, loff_t *, long);
int mfs_client_readdir(int, mfs_handle_t, struct file *, void *, filldir_t, int, int, int *, int *);
int mfs_client_ioctl(int, mfs_handle_t, struct file *, unsigned int, unsigned long, int, int *);
int mfs_client_open(int, mfs_handle_t, struct file *);
int mfs_client_fsync(int, mfs_handle_t, struct file *, int);
int mfs_client_revalidate(int, mfs_handle_t, struct subinode *);
int mfs_client_express_lookup(int, mfs_handle_t *, char *, unsigned int, struct subinode *, char **, struct mfs_completion *);
char *mfs_client_check_path(int, mfs_handle_t);
int mfs_client_setattr(int, mfs_handle_t, struct iattr *);
void mfs_throw_garbage(void);
int mfs_client_daemon(void *);
int mfs_kill(char *);
void mfs_tuneinfo(char *);
#ifdef CONFIG_MOSIX_DFSA
int mfs_add_stats(struct mfs_stats *, struct mfs_stats *, struct mosix_task *);
#else
static inline int mfs_add_stats(struct mfs_stats *x, struct mfs_stats *y, struct mosix_task *z)
{
	return(0);
}
#endif /* CONFIG_MOSIX_DFSA */

extern struct task_struct *mfs_main_server_task;

static inline int
file_is_mfs(struct file *file)
{
	struct dentry *dp;
	struct inode *ip;
	struct super_block *sb;

	return(file && (dp = file->f_dentry) && (ip = dp->d_inode) &&
		(sb = ip->i_sb) && sb->s_magic == MFS_SUPER_MAGIC);
}

/* statistic collection: */

#ifdef CONFIG_MOSIX_DFSA
extern void mfs_count(int, int, int);

#define	mfs_count_attach_handle(w)	mfs_count(w, 0, 0)
#define	mfs_count_touch_handle(w)	mfs_count(w, 0, 0)
#define	mfs_count_dispose_handle(w)	mfs_count(w, 0, 0)
#define	mfs_count_llseek(w)		mfs_count(w, 0, 0)
#define	mfs_count_read(w,n)		mfs_count(w, n, 0)
#define	mfs_count_write(w,n)		mfs_count(w, 0, n)
#define	mfs_count_readdir(w,p,b)	mfs_count(w, b, (p) * sizeof(int))
#define	mfs_count_ioctl(w)		mfs_count(w, 0, 0)
#define	mfs_count_open(w)		mfs_count(w, 0, 0)
#define	mfs_count_fsync(w)		mfs_count(w, 0, 0)
#define	mfs_count_setattr(w)		mfs_count(w, 0, 0)
#define	mfs_count_revalidate(w)		mfs_count(w, 0, 0)
#define	mfs_count_express(w,l) 		mfs_count(w, 0, l)
#define	mfs_count_check_path(w,l)	mfs_count(w, 0, l)
#define	mfs_count_notify_change(w)	mfs_count(w, 0, 0)
#define mfs_count_statfs(w)             mfs_count(w, 0, 0)
#else
#define	mfs_count_attach_handle(w)	do {} while(0)
#define	mfs_count_touch_handle(w)	do {} while(0)
#define	mfs_count_dispose_handle(w)	do {} while(0)
#define	mfs_count_llseek(w)		do {} while(0)
#define	mfs_count_read(w,n)		do {} while(0)
#define	mfs_count_write(w,n)		do {} while(0)
#define	mfs_count_readdir(w,p,b)	do {} while(0)
#define	mfs_count_ioctl(w)		do {} while(0)
#define	mfs_count_open(w)		do {} while(0)
#define	mfs_count_fsync(w)		do {} while(0)
#define	mfs_count_setattr(w)		do {} while(0)
#define	mfs_count_revalidate(w)		do {} while(0)
#define	mfs_count_express(w,l)	do {} while(0)
#define	mfs_count_check_path(w,l)	do {} while(0)
#define	mfs_count_notify_change(w)	do {} while(0)A
#define mfs_count_statfs(w) 		do {} while(0)
#endif /* CONFIG_MOSIX_DFSA */

#endif /* _MFS_H */
