#ifndef _LINUX_FS_STRUCT_H
#define _LINUX_FS_STRUCT_H
#ifdef __KERNEL__

#ifdef CONFIG_MOSIX_DFSA
#include <linux/dfsa_interface.h>
#endif /* CONFIG_MOSIX_DFSA */

struct fs_struct {
	atomic_t count;
	rwlock_t lock;
	int umask;
	struct dentry * root, * pwd, * altroot;
	struct vfsmount * rootmnt, * pwdmnt, * altrootmnt;
#ifdef CONFIG_MOSIX_DFSA
	atomic_t users;
	short count_dropped_to_one;
	short pwd_changed;
#define	INIT_FS_DFSA	, ATOMIC_INIT(1), 0, 0
#else
#define	INIT_FS_DFSA
#endif /* CONFIG_MOSIX_DFSA */
};

#define INIT_FS { \
	ATOMIC_INIT(1), \
	RW_LOCK_UNLOCKED, \
	0022, \
	NULL, NULL, NULL, NULL, NULL, NULL \
	INIT_FS_DFSA \
}

extern void exit_fs(struct task_struct *);
extern void set_fs_altroot(void);

/*
 * Replace the fs->{rootmnt,root} with {mnt,dentry}. Put the old values.
 * It can block. Requires the big lock held.
 */

static inline void set_fs_root(struct fs_struct *fs,
	struct vfsmount *mnt,
	struct dentry *dentry)
{
	struct dentry *old_root;
	struct vfsmount *old_rootmnt;
	write_lock(&fs->lock);
	old_root = fs->root;
	old_rootmnt = fs->rootmnt;
	fs->rootmnt = mntget(mnt);
	fs->root = dget(dentry);
	write_unlock(&fs->lock);
	if (old_root) {
		dput(old_root);
		mntput(old_rootmnt);
	}
#ifdef CONFIG_MOSIX_DFSA
	dfsa_is_not_up_to_date();
#endif /* CONFIG_MOSIX_DFSA */
}

/*
 * Replace the fs->{pwdmnt,pwd} with {mnt,dentry}. Put the old values.
 * It can block. Requires the big lock held.
 */

static inline void set_fs_pwd(struct fs_struct *fs,
	struct vfsmount *mnt,
	struct dentry *dentry)
{
	struct dentry *old_pwd;
	struct vfsmount *old_pwdmnt;
	write_lock(&fs->lock);
	old_pwd = fs->pwd;
	old_pwdmnt = fs->pwdmnt;
	fs->pwdmnt = mntget(mnt);
	fs->pwd = dget(dentry);
	write_unlock(&fs->lock);
#ifdef CONFIG_MOSIX_DFSA
	if(fs->pwdmnt != old_pwdmnt || fs->pwd != old_pwd)
		dfsa_pwd_changed();
#endif /* CONFIG_MOSIX_DFSA */
	if (old_pwd) {
		dput(old_pwd);
		mntput(old_pwdmnt);
	}
}

struct fs_struct *copy_fs_struct(struct fs_struct *old);
void put_fs_struct(struct fs_struct *fs);
#ifdef CONFIG_MOSIX_DFSA
void put_used_fs_struct(struct fs_struct *fs);
#endif /* CONFIG_MOSIX_DFSA */

#endif
#endif
