/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Amnon Shiloh.
 */
/* DFSA definitions and functions required anywhere outside of MOSIX */
#ifndef _MOS_DFSA_INTERFACE_H
#define _MOS_DFSA_INTERFACE_H

#ifdef CONFIG_MOSIX_DFSA

/* update flags (dupdates): */

#define	DFSA_UPDCRED	1	/* need to update credentials */
#define	DFSA_UPDTABLE	2	/* need to update DFSA table */
#define	DFSA_UPDCDIR	4	/* need to update current-directory */
#define	DFSA_UPDMAX	8	/* need to update "max_fdset" */
#define	DFSA_UPDCLOSE	16	/* need to update closed files */
#define	DFSA_UPDOPEN	32	/* need to update opened files */
#define	DFSA_UPDMODS	64	/* need to update modified files */
#define	DFSA_UPDUSED	128	/* need to update the "used" bits */
#define	DFSA_UPDSEL	256	/* need to update MFS node-selections */
#define	DFSA_UPDUMASK	512	/* need to update umask */

#define	DFSA_UPDATE	(DFSA_UPDCRED|DFSA_UPDTABLE|DFSA_UPDCDIR|DFSA_UPDMAX|\
			 DFSA_UPDCLOSE|DFSA_UPDOPEN|DFSA_UPDMODS|DFSA_UPDUSED|\
			 DFSA_UPDSEL|DFSA_UPDUMASK)

#define CAN_DFSA(p)	((p)->fs && atomic_read(&(p)->fs->users) == 1 && \
			!(p)->fs->altroot && \
			(p)->files && atomic_read(&(p)->files->users) == 1 && \
			(p)->fs->root == init_task.fs->root && \
			(p)->fs->rootmnt == init_task.fs->rootmnt && \
			!((p)->ptrace) && !(p->flags & PF_EXITING))

/* adjust the following if any file-system requires more identifying bytes: */
#define	MAX_IDENT_RECORD_LEN	20

struct vfsmount;
struct dentry;
struct nameidata;
struct file;

void dfsa_init(void);
int dfsa_setmnt(struct vfsmount *, int, unsigned long);
int dfsa_option(char *, int *);
void dfsa_close_file(int);
void dfsa_open_file(int);
void dfsa_touch_file(int);
void dfsa_is_not_up_to_date(void);
void dfsa_pwd_changed(void);
int can_dfsa_file(int);
void dfsa_syscall_on_file(int, int);
int name_starts_in_dfsa(char **, struct nameidata *);
int within_dfsa(struct nameidata *);
int dfsa_optimized_read(struct file *, loff_t, unsigned long, unsigned long);
int disable_dfsa(void);
void enable_dfsa(void);

#endif /* CONFIG_MOSIX_DFSA */
#endif
