/*
 * tunable variables
 */

/* When changing these variable - recompile c.c
 * and the named files
 */

#ifndef UKC1134
#define	NBUF	19		/* size of buffer cache */
				/* bio.c */
#endif
#ifdef UKC1134
#define NBUF	20
#endif
#define	NINODE	125		/* number of in core inodes */
				/* alloc.c, clock.c, iget.c, sys3.c */
#define	NFILE	80		/* number of in core file structures */
				/* fio.c */
#define	NMOUNT	5		/* number of mountable file systems */
				/* alloc.c, iget.c, sys3.c */
#define NCARGS	5120		/* No of chars in arglist */
#define	MAXMEM	(64*32)		/* max core per process - first # is Kw */
#define	SSIZE	20		/* initial stack size (*64 bytes) */
#define	SINCR	20		/* increment of stack (*64 bytes) */
#define	NOFILE	15		/* max open files per process */
#define	CANBSIZ	256		/* max size of typewriter line */
#define	CMAPSIZ	71		/* size of core allocation area */
				/* odd - because of end of map indicator */
				/* main.c */
#define	SMAPSIZ	71		/* size of swap allocation area */
				/* odd - because of end of map indicator */
				/* main.c */
#define	NCALL	16		/* max simultaneous time callouts */
#define	NPROC	50		/* max number of processes */
				/* slp.c, sys1.c */
#define	NTEXT	50		/* max number of pure texts */
				/* text.c */
#define	NCLIST	88		/* max total clist size */
				/* tty.c */
#define	HZ	50		/* Ticks/second of the clock */

/*
 * priorities
 * probably should not be
 * altered too much
 */

#define	PSWP	-100
#define	PINOD	-90
#define	PRIBIO	-50
#define	PPIPE	1
#define	PWAIT	40
#define	PSLEP	90
#define	PUSER	100

/*
 * signals
 * dont change
 */

#define	NSIG	20
#define		SIGHUP	1	/* hangup */
#define		SIGINT	2	/* interrupt (rubout) */
#define		SIGQIT	3	/* quit (FS) */
#define		SIGINS	4	/* illegal instruction */
#define		SIGTRC	5	/* trace or breakpoint */
#define		SIGIOT	6	/* iot */
#define		SIGEMT	7	/* emt */
#define		SIGFPT	8	/* floating exception */
#define		SIGKIL	9	/* kill */
#define		SIGBUS	10	/* bus error */
#define		SIGSEG	11	/* segmentation violation */
#define		SIGSYS	12	/* sys */
#define		SIGPIPE	13	/* end of pipe */
#define		SIGCLK	14	/* New signal for NEW_SLEEP - alarm wakeup */

/*
 * fundamental constants
 * cannot be changed
 */

#define	USIZE	16		/* size of user block (*64) */
#define	NULL	0
#define	NODEV	(-1)
#define	ROOTINO	1		/* i number of all roots */
#define	DIRSIZ	14		/* max characters per directory */

/*
 * structure to access an
 * integer in bytes
 */
struct
{
	char	lobyte;
	char	hibyte;
};

/*
 * structure to access an integer
 */
struct
{
	int	integ;
};

/*
 * Certain pror registers
 */
#define PS	0177776
#define KL	0177560
#define SW	0177570

/*
 *	Most times have been converted to longs which compile the
 *	correct code but we need the following structure in some
 *	circumstances
 */

struct
{	int	hiint;
	int	loint;
};

/*
 *	The following definitions refer to system changes - see
 *	the file changes.h
 */

#define	_1140 0
#define ERRLOG 0
#define	RAW_BUFFER_POOL 0
#define	NRAWBUFS	6
#define	BETTER_TIME 0
#define MEMPARITY 0
#define WAITABAN 0
#define ctos(x) ((x+127YNCHR)>>7)
#define nseg(x) ctos(x)
#define ctob(x) ((x+7)>>3)
#define PIPEFIX 0
#define B_AGE 0200
#define MAXMIN 0
#ifdef MAXMIN
struct
{	unsigned	m_unsign;	};
#define min(a, b) (a.m_unsign < b ? a : b)
#define max(a, b) (a.m_unsign > b? a : b)
#endif
#define LRU_INODE 0
#define QEXEC 0
#define NEW_SLEEP 0
#define TELL 0
#define NEWTRACE 
