/ machine language assist
/ for 11/40

/ Modified by Peter Collinson Nov 76
/ To allow killunix program
/ New bit added in to label called stopit
/ Label called stopit added in by Peter C to allow system halt
/ Modified by Bob Eager UKC May 77
/ to allow dump to RK05 disk on system crash
/ Works like the old mag tape dump
/ Dumps to block 4000 onwards in case some idiot tries
/ to dump to the system disk. (goes harmlessly into swap area)

/ Modified Peter C Aug 77
/ to include new clist function zapc
/ used to support new tty driver

/ Modified March-April 1978 Peter Collinson
/ to include new versions of putc and getc from UNSW
/ saves 20 bytes and is a bit quicker
/ also to modify call routine to make t-bit
/ tracing work properly see trap.c & param.h (PROPER_TRAP)

/ Modified September 1979 Peter Collinson
/ to alter copyseg and clearseg to non mfpi versions
/ obtained (as usual) from UNSW

/ non-UNIX instructions
mfpi	= 6500^tst
mtpi	= 6600^tst
halt	= 0
wait	= 1
rtt	= 6
rti	= 2
reset	= 5

.globl	trap, call
.globl	_trap
trap:
	mov	PS,-4(sp)
	tst	nofault
	bne	1f
	mov	SSR0,ssr
	mov	SSR2,ssr+4
	mov	$1,SSR0
	jsr	r0,call1; _trap
	/ no return
1:
	mov	$1,SSR0
	mov	nofault,(sp)
	rtt

.globl	_runrun, _swtch
call1:
	tst	-(sp)
	bic	$340,PS
	br	1f

call:
	mov	PS,-(sp)
1:
	mov	r1,-(sp)
	mfpi	sp
	mov	4(sp),-(sp)
	bic	$!37,(sp)
	bit	$30000,PS
	beq	1f
	jsr	pc,*(r0)+
2:
	bis	$340,PS
	tstb	_runrun
	beq	2f
	bic	$340,PS
	jsr	pc,_swtch
	br	2b
2:
	tst	(sp)+
	mtpi	sp
	br	2f
1:
	bis	$30000,PS
	jsr	pc,*(r0)+
	cmp	(sp)+,(sp)+
2:
	mov	(sp)+,r1
	tst	(sp)+
	mov	(sp)+,r0
	/	chrism & gregr to make t bit tracing work
	/ for system calls. ps bits 8-11 set if bpt trap occurred
	bit	$3400,2(sp)
	bne	9f
	rti
9:	bic	$3400,2(sp)
	rtt


.globl	_savfp, _display
_savfp:
_display:
	rts	pc

.globl	_incupc
_incupc:
	mov	r2,-(sp)
	mov	6(sp),r2	/ base of prof with base,leng,off,scale
	mov	4(sp),r0	/ pc
	sub	4(r2),r0	/ offset
	clc
	ror	r0
	mul	6(r2),r0	/ scale
	ashc	$-14.,r0
	inc	r1
	bic	$1,r1
	cmp	r1,2(r2)	/ length
	bhis	1f
	add	(r2),r1		/ base
	mov	nofault,-(sp)
	mov	$2f,nofault
	mfpi	(r1)
	inc	(sp)
	mtpi	(r1)
	br	3f
2:
	clr	6(r2)
3:
	mov	(sp)+,nofault
1:
	mov	(sp)+,r2
	rts	pc

/ Character list get/put
/ UNSW version moded for constants
/ works with a cblock size of 16 bytes

.globl	_getc, _putc
.globl	_cfreelist


/	c = getc( cp )		struct clist *cp;

_getc:
	mov	r2,-(sp)
	mov	4(sp),r2
	mov	PS,-(sp)
	bis	$340,PS		/spl 5
	bic	$100,PS
	mov	2(r2),r1	/ first ptr
	beq	5f		/ buffer empty
0:
	movb	(r1)+,r0
	bic	$!377,r0
	dec	(r2)+		/ update count
	beq	4f		/ return last block to free
	bit	$017,r1
	beq	2f		/ return empty block to free
	mov	r1,(r2)
1:
	mov	(sp)+,PS
	mov	(sp)+,r2
	rts	pc

2:
	sub	$20,r1
	mov	(r1),(r2)
	add	$2,(r2)		/ update first pointer
3:
	mov	_cfreelist,(r1)
	mov	r1,_cfreelist
	br	1b

4:
	clr	(r2)+
	clr	(r2)
	dec	r1
	bic	$017,r1
	br	3b

5:
	mov	$-1,r0
	br	1b


/	putc( c , cp )		struct clist *cp;

_putc:
	mov	4(sp),r0
	mov	PS,-(sp)
	bis	$340,PS		/spl 5
	bic	$100,PS
	mov	4(r0),r1	/ last ptr
	beq	4f		/ buffer empty
	bit	$017,r1
	beq	2f		/ block full
0:
	movb	4(sp),(r1)+
	mov	r1,4(r0)
	inc	(r0)		/ update count
	clr	r0
1:
	mov	(sp)+,PS
	rts	pc

2:
	sub	$020,r1
	mov	_cfreelist,-(sp)
	beq	3f		/ freelist empty ( r0 != 0 )
	mov	*(sp),_cfreelist
	mov	(sp),(r1)
	mov	(sp)+,r1
	clr	(r1)+
	br	0b

3:
	tst	(sp)+
	br	1b

4:
	mov	_cfreelist,r1
	beq	1b		/ freelist empty ( r0 != 0 )
	mov	(r1),_cfreelist
	clr	(r1)+
	mov	r1,2(r0)	/ set first ptr
	br	0b

.globl	_zapc
_zapc:
	mov	2(sp),r1
	mov	PS,-(sp)
	mov	r2,-(sp)
	mov	r3,-(sp)
	bis	$340,PS
	bic	$100,PS		/ spl5

	tst	(r1)		/ empty
	beq	9f
	mov	4(r1),r2	/ r2 points at last char +1
	dec	r2
	movb	(r2),r0		/ fetch char
	bic	$!377,r0
	cmp	$377,r0		/ is char a CDELIM
	beq	9f

	dec	(r1)+		/ count
	bne	4f		/ queue now empty ?
	clr	(r1)+		/ zero first and last char
	clr	(r1)
	bic	$17,r2		/ address of block (was 7)
	br	5f
4:
	mov	r2,2(r1)	/ update last char
	dec	r2		/ last block is empty ?
	dec	r2
	bit	$17,r2		/was 7
	bne	3f

	mov	(r1)+,r3	/ afraid so, get
	bic	$17,r3		/ address of first block (was 7)
1:	cmp	(r3),r2		/ trog down the links,
	beq	2f		/ until r3 points at r2
	mov	(r3),r3
	br	1b
2:	clr	(r3)		/ unlink block r2
	add	$20,r3		/ set r3 to char beyond block (was 10)
	mov	r3,(r1)		/ update last char
5:
	mov	_cfreelist,(r2)	/ free r2
	mov	r2,_cfreelist

3:
	mov	(sp)+,r3
	mov	(sp)+,r2
	mov	(sp)+,PS
	rts	pc
9:
	mov	$-1,r0		/ failed
	br	3b


.globl	_backup
.globl	_regloc
_backup:
	mov	2(sp),ssr+2
	mov	r2,-(sp)
	jsr	pc,backup
	mov	r2,ssr+2
	mov	(sp)+,r2
	movb	jflg,r0
	bne	2f
	mov	2(sp),r0
	movb	ssr+2,r1
	jsr	pc,1f
	movb	ssr+3,r1
	jsr	pc,1f
	movb	_regloc+7,r1
	asl	r1
	add	r0,r1
	mov	ssr+4,(r1)
	clr	r0
2:
	rts	pc
1:
	mov	r1,-(sp)
	asr	(sp)
	asr	(sp)
	asr	(sp)
	bic	$!7,r1
	movb	_regloc(r1),r1
	asl	r1
	add	r0,r1
	sub	(sp)+,(r1)
	rts	pc

/ hard part
/ simulate the ssr2 register missing on 11/40

backup:
	clr	r2		/ backup register ssr1
	mov	$1,bflg		/ clrs jflg
	mov	ssr+4,r0
	jsr	pc,fetch
	mov	r0,r1
	ash	$-11.,r0
	bic	$!36,r0
	jmp	*0f(r0)
0:		t00; t01; t02; t03; t04; t05; t06; t07
		t10; t11; t12; t13; t14; t15; t16; t17

t00:
	clrb	bflg

t10:
	mov	r1,r0
	swab	r0
	bic	$!16,r0
	jmp	*0f(r0)
0:		u0; u1; u2; u3; u4; u5; u6; u7

u6:	/ single op, m[tf]pi, sxt, illegal
	bit	$400,r1
	beq	u5		/ all but m[tf], sxt
	bit	$200,r1
	beq	1f		/ mfpi
	bit	$100,r1
	bne	u5		/ sxt

/ simulate mtpi with double (sp)+,dd
	bic	$4000,r1	/ turn instr into (sp)+
	br	t01

/ simulate mfpi with double ss,-(sp)
1:
	ash	$6,r1
	bis	$46,r1		/ -(sp)
	br	t01

u4:	/ jsr
	mov	r1,r0
	jsr	pc,setreg	/ assume no fault
	bis	$173000,r2	/ -2 from sp
	rts	pc

t07:	/ EIS
	clrb	bflg

u0:	/ jmp, swab
u5:	/ single op
	mov	r1,r0
	br	setreg

t01:	/ mov
t02:	/ cmp
t03:	/ bit
t04:	/ bic
t05:	/ bis
t06:	/ add
t16:	/ sub
	clrb	bflg

t11:	/ movb
t12:	/ cmpb
t13:	/ bitb
t14:	/ bicb
t15:	/ bisb
	mov	r1,r0
	ash	$-6,r0
	jsr	pc,setreg
	swab	r2
	mov	r1,r0
	jsr	pc,setreg

/ if delta(dest) is zero,
/ no need to fetch source

	bit	$370,r2
	beq	1f

/ if mode(source) is R,
/ no fault is possible

	bit	$7000,r1
	beq	1f

/ if reg(source) is reg(dest),
/ too bad.

	mov	r2,-(sp)
	bic	$174370,(sp)
	cmpb	1(sp),(sp)+
	beq	t17

/ start source cycle
/ pick up value of reg

	mov	r1,r0
	ash	$-6,r0
	bic	$!7,r0
	movb	_regloc(r0),r0
	asl	r0
	add	ssr+2,r0
	mov	(r0),r0

/ if reg has been incremented,
/ must decrement it before fetch

	bit	$174000,r2
	ble	2f
	dec	r0
	bit	$10000,r2
	beq	2f
	dec	r0
2:

/ if mode is 6,7 fetch and add X(R) to R

	bit	$4000,r1
	beq	2f
	bit	$2000,r1
	beq	2f
	mov	r0,-(sp)
	mov	ssr+4,r0
	add	$2,r0
	jsr	pc,fetch
	add	(sp)+,r0
2:

/ fetch operand
/ if mode is 3,5,7 fetch *

	jsr	pc,fetch
	bit	$1000,r1
	beq	1f
	bit	$6000,r1
	bne	fetch
1:
	rts	pc

t17:	/ illegal
u1:	/ br
u2:	/ br
u3:	/ br
u7:	/ illegal
	incb	jflg
	rts	pc

setreg:
	mov	r0,-(sp)
	bic	$!7,r0
	bis	r0,r2
	mov	(sp)+,r0
	ash	$-3,r0
	bic	$!7,r0
	movb	0f(r0),r0
	tstb	bflg
	beq	1f
	bit	$2,r2
	beq	2f
	bit	$4,r2
	beq	2f
1:
	cmp	r0,$20
	beq	2f
	cmp	r0,$-20
	beq	2f
	asl	r0
2:
	bisb	r0,r2
	rts	pc

0:	.byte	0,0,10,20,-10,-20,0,0

fetch:
	bic	$1,r0
	mov	nofault,-(sp)
	mov	$1f,nofault
	mfpi	(r0)
	mov	(sp)+,r0
	mov	(sp)+,nofault
	rts	pc

1:
 	mov	(sp)+,nofault
	clrb	r2			/ clear out dest on fault
	mov	$-1,r0
	rts	pc

.bss
bflg:	.=.+1
jflg:	.=.+1
.text

.globl	_fubyte, _subyte
.globl	_fuibyte, _suibyte
.globl	_fuword, _suword
.globl	_fuiword, _suiword
_fuibyte:
_fubyte:
	mov	2(sp),r1
	bic	$1,r1
	jsr	pc,gword
	cmp	r1,2(sp)
	beq	1f
	swab	r0
1:
	bic	$!377,r0
	rts	pc

_suibyte:
_subyte:
	mov	2(sp),r1
	bic	$1,r1
	jsr	pc,gword
	mov	r0,-(sp)
	cmp	r1,4(sp)
	beq	1f
	movb	6(sp),1(sp)
	br	2f
1:
	movb	6(sp),(sp)
2:
	mov	(sp)+,r0
	jsr	pc,pword
	clr	r0
	rts	pc

_fuiword:
_fuword:
	mov	2(sp),r1
fuword:
	jsr	pc,gword
	rts	pc

gword:
	mov	PS,-(sp)
	bis	$340,PS
	mov	nofault,-(sp)
	mov	$err,nofault
	mfpi	(r1)
	mov	(sp)+,r0
	br	1f

_suiword:
_suword:
	mov	2(sp),r1
	mov	4(sp),r0
suword:
	jsr	pc,pword
	rts	pc

pword:
	mov	PS,-(sp)
	bis	$340,PS
	mov	nofault,-(sp)
	mov	$err,nofault
	mov	r0,-(sp)
	mtpi	(r1)
1:
	mov	(sp)+,nofault
	mov	(sp)+,PS
	rts	pc

err:
	mov	(sp)+,nofault
	mov	(sp)+,PS
	tst	(sp)+
	mov	$-1,r0
	rts	pc

.globl	_copyin, _copyout
_copyin:
	jsr	pc,copsu
1:
	mfpi	(r0)+
	mov	(sp)+,(r1)+
	sob	r2,1b
	br	2f

_copyout:
	jsr	pc,copsu
1:
	mov	(r0)+,-(sp)
	mtpi	(r1)+
	sob	r2,1b
2:
	mov	(sp)+,nofault
	mov	(sp)+,r2
	clr	r0
	rts	pc

copsu:
	mov	(sp)+,r0
	mov	r2,-(sp)
	mov	nofault,-(sp)
	mov	r0,-(sp)
	mov	10(sp),r0
	mov	12(sp),r1
	mov	14(sp),r2
	asr	r2
	mov	$1f,nofault
	rts	pc

1:
	mov	(sp)+,nofault
	mov	(sp)+,r2
	mov	$-1,r0
	rts	pc

.globl	_idle
_idle:
	mov	PS,-(sp)
	bic	$340,PS
	wait
	mov	(sp)+,PS
	rts	pc

.globl	_savu, _retu, _aretu
_savu:
	bis	$340,PS
	mov	(sp)+,r1
	mov	(sp),r0
	mov	sp,(r0)+
	mov	r5,(r0)+
	bic	$340,PS
	jmp	(r1)

_aretu:
	bis	$340,PS
	mov	(sp)+,r1
	mov	(sp),r0
	br	1f

_retu:
	bis	$340,PS
	mov	(sp)+,r1
	mov	(sp),KISA6
	mov	$_u,r0
1:
	mov	(r0)+,sp
	mov	(r0)+,r5
	bic	$340,PS
	jmp	(r1)

.globl	_spl0, _spl1, _spl4, _spl5, _spl6, _spl7
_spl0:
	bic	$340,PS
	rts	pc

_spl1:
	bis	$40,PS
	bic	$300,PS
	rts	pc

_spl4:
_spl5:
	bis	$340,PS
	bic	$100,PS
	rts	pc

_spl6:
	bis	$340,PS
	bic	$40,PS
	rts	pc

_spl7:
	bis	$340,PS
	rts	pc

.globl	_copyseg
.globl	_parfail
_copyseg:
parvec = 114
	mov	PS, -(sp)		/ save priority etc
	mov	r2, -(sp)
	mov	$4*20000, r0
	mov	$5*20000, r1
	mov	$8., r2			/ count for sobbing
	mov	*$parvec,-(sp)		/ in case of parity
	mov	$3f,*$parvec
	bis	$340,PS			/ spl 7
	mov	10(sp), KISA4		/ from addr
	mov	12(sp), KISA5		/ to addr
1:
	mov	(r0)+, (r1)+
	mov	(r0)+, (r1)+
	mov	(r0)+, (r1)+
	mov	(r0)+, (r1)+
	sob	r2, 1b

	mov	$4*200, KISA4
	mov	$5*200, KISA5
	mov	(sp)+, *$parvec
	mov	(sp)+, r2
	mov	(sp)+, PS
	rts	pc
3:	/ new parity trap routine
	/ go straight to parity fail routine
	mov	$4*200, KISA4
4:
	mov	$5*200,KISA5
	mov	4(sp),*$parvec		/ reset parity vec
	bic	$340,PS			/ spl0
	jsr	pc,_parfail
	jbr	_stopit			/ jump in case of return
/	Old version of copyseg
/	mov	PS,-(sp)
/	mov	UISA0,-(sp)
/	mov	UISA1,-(sp)
/	mov	$30340,PS
/	mov	10(sp),UISA0
/	mov	12(sp),UISA1
/	mov	UISD0,-(sp)
/	mov	UISD1,-(sp)
/	mov	$6,UISD0
/	mov	$6,UISD1
/	mov	r2,-(sp)
/	clr	r0
/	mov	$8192.,r1
/	mov	$32.,r2
/1:
/	mfpi	(r0)+
/	mtpi	(r1)+
/	sob	r2,1b
/	mov	(sp)+,r2
/	mov	(sp)+,UISD1
/	mov	(sp)+,UISD0
/	mov	(sp)+,UISA1
/	mov	(sp)+,UISA0
/	mov	(sp)+,PS
/	rts	pc

.globl	_clearseg
_clearseg:
parvec = 114
	mov	$5*20000, r0
	mov	$8., r1			/ count for sobbing
	mov	PS, -(sp)		/ save priority etc
	mov	*$parvec,-(sp)		/ in case of parody
	mov	$4b,*$parvec
	bis	$340,PS			/ spl 7
	mov	6(sp), KISA5		/ to addr
1:
	clr	(r0)+
	clr	(r0)+
	clr	(r0)+
	clr	(r0)+
	sob	r1, 1b

	mov	$5*200, KISA5
	mov	(sp)+, *$parvec
	mov	(sp)+, PS
	rts	pc
/ Old version of clearseg
/	mov	PS,-(sp)
/	mov	UISA0,-(sp)
/	mov	$30340,PS
/	mov	6(sp),UISA0
/	mov	UISD0,-(sp)
/	mov	$6,UISD0
/	clr	r0
/	mov	$32.,r1
/1:
/	clr	-(sp)
/	mtpi	(r0)+
/	sob	r1,1b
/	mov	(sp)+,UISD0
/	mov	(sp)+,UISA0
/	mov	(sp)+,PS
/	rts	pc

.globl	_dpadd
_dpadd:
	mov	2(sp),r0
	add	4(sp),2(r0)
	adc	(r0)
	rts	pc

.globl	_dpcmp
_dpcmp:
	mov	2(sp),r0
	mov	4(sp),r1
	sub	6(sp),r0
	sub	8(sp),r1
	sbc	r0
	bge	1f
	cmp	r0,$-1
	bne	2f
	cmp	r1,$-512.
	bhi	3f
2:
	mov	$-512.,r0
	rts	pc
1:
	bne	2f
	cmp	r1,$512.
	blo	3f
2:
	mov	$512.,r1
3:
	mov	r1,r0
	rts	pc

.globl	dump
dump:
	bit	$1,SSR0
	bne	dump

/ save regs r0,r1,r2,r3,r4,r5,r6,KIA6
/ starting at abs location 4

	mov	r0,4
	mov	$6,r0
	mov	r1,(r0)+
	mov	r2,(r0)+
	mov	r3,(r0)+
	mov	r4,(r0)+
	mov	r5,(r0)+
	mov	sp,(r0)+
	mov	KISA6,(r0)+

/ dump all of core to RK05 disk on drive 0
/ added by Bob Eager UKC May 77

DMPBLK	= 4000.			/ dump block no - 4000 means only the swap
				/ area gets overwritten if system disk used
				/ by mistake!

	mov	$DMPBLK,r0
	mov	$14,r3		/ convert block no to RKDA format
1:
	sub	$14,r0
	bmi	2f
	add	$20,r3
	br	1b
2:
	add	r3,r0

/ we now have the disk address in r0
/ now add in the drive number, taken from bits
/ 0 to 2 of the switch register

	mov	*$SWR,r1
	ash	$15,r1		/ put in correct place
	bis	r1,r0

/ now start poking around with the disk

	mov	$RKCS,r1
	mov	$2,(r1)+	/ write function
	clr	2(r1)		/ bus address
	mov	r0,4(r1)	/ disk address
1:
	mov	$-4096.,(r1)	/ word count
	inc	-(r1)		/ go!
2:
	tstb	(r1)		/ wait for ready bit
	bpl	2b		/ not yet
	tst	(r1)+		/ error?
	bpl	1b		/ no, keep on truckin'
	reset			/ die hard
	halt			/ use halt so we can see when
				/ the dump has finished

/ Inserted by Peter C to allow full  halt of system stop
.globl	_stopit
_stopit:
/ Set illegal instruction trap registers to bootstrap
/ address to cause less pain to idiots who will insist
/ on bootstrapping their systems with bit 0 in the
/ switch register set to 1
	mov	$173000,*$4
	mov	$0340,*$6
	reset
	halt

.globl	start, _end, _edata, _main
start:
	bit	$1,SSR0
	bne	start			/ loop if restart
	reset

/ initialize systems segments

	mov	$KISA0,r0
	mov	$KISD0,r1
	mov	$200,r4
	clr	r2
	mov	$6,r3
1:
	mov	r2,(r0)+
	mov	$77406,(r1)+		/ 4k rw
	add	r4,r2
	sob	r3,1b

/ initialize user segment

	mov	$_end+63.,r2
	ash	$-6,r2
	bic	$!1777,r2
	mov	r2,(r0)+		/ ksr6 = sysu
	mov	$usize-1\<8|6,(r1)+

/ initialize io segment
/ set up counts on supervisor segments

	mov	$IO,(r0)+
	mov	$77406,(r1)+		/ rw 4k

/ get a sp and start segmentation

	mov	$_u+[usize*64.],sp
	inc	SSR0

/ clear bss

	mov	$_edata,r0
1:
	clr	(r0)+
	cmp	r0,$_end
	blo	1b

/ clear user block

	mov	$_u,r0
1:
	clr	(r0)+
	cmp	r0,$_u+[usize*64.]
	blo	1b

/ set up previous mode and call main
/ on return, enter user mode at 0R

	mov	$30000,PS
	jsr	pc,_main
	mov	$170000,-(sp)
	clr	-(sp)
	rtt

.globl	_ldiv
_ldiv:
	clr	r0
	mov	2(sp),r1
	div	4(sp),r0
	rts	pc

.globl	_lrem
_lrem:
	clr	r0
	mov	2(sp),r1
	div	4(sp),r0
	mov	r1,r0
	rts	pc

.globl	_lshift
_lshift:
	mov	2(sp),r1
	mov	(r1)+,r0
	mov	(r1),r1
	ashc	4(sp),r0
	mov	r1,r0
	rts	pc

/ Modified version to support new compiler
.globl	csv
csv:
	mov	r5,r0
	mov	sp,r5
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	jsr	pc,(r0)

.globl cret
cret:
	mov	r5,r2
	mov	-(r2),r4
	mov	-(r2),r3
	mov	-(r2),r2
	mov	r5,sp
	mov	(sp)+,r5
	rts	pc

.globl	_u
_u	= 140000
usize	= 16.

PS	= 177776
SWR	= 177570
SSR0	= 177572
SSR2	= 177576
KISA0	= 172340
KISA4	= 172350
KISA5	= 172352
KISA6	= 172354
KISD0	= 172300
RKCS	= 177404	/ RK11 control and status (for crash dump)
UISA0	= 177640
UISA1	= 177642
UISD0	= 177600
UISD1	= 177602
IO	= 7600

.data
.globl	_ka6, _cputype
_ka6:	KISA6
_cputype:40.

.bss
.globl	nofault, ssr, badtrap
nofault:.=.+2
ssr:	.=.+6
badtrap:.=.+2
