	/*
	 *	This file contains a list of changes which
	 *	have been made to the UKC UNIX V6 system
	 *	There are two sorts of alterations
	 *
	 *	1)	changes made to the code, where the old code has been removed
	 *		Usually after a period of testing
	 *	2)	changes delimited by #ifdef statements, the code can still be removed
	 *		and the old version should work.
	 *		The relevant ifdef statements should be included in param.h
	 */


	/*
	 *
	 *
	 *	ALTERATIONS TO THE CODE
	 *
	 *
	 */
/*
#define STOPUNIX
	/*
	 *	Peter Collinson UKC
	 *	1977
	 *
	 *	sys4.c sysent.c
	 *
	 *	Creates a new system call which when activated stops the
	 *	processor after doing update() etc.
	 *	This mod ended all the trouble which we had in taking the system down.
	 */

/*
#define NEW_TTY
	/*
	 *	Glasgow, from QMC from the States
	 *	Installed at UKC 1977
	 *
	 *	tty.c tty.h systm.h m40.s - new routine zapc()
	 *	dc.c kl.c etc
	 *
	 *	A revised and better teletype driver with lots of
	 *	new facilities
	 */
/*
#define LONG_TIME
	/*
	 *	This is UKC internal name for fix000 from UNSW
	 *	takes advantage of the 'long' types in the C compiler
 	 *	the only items which have been made 'long' are those
 	 *	pertaining to time
	 *
	 *	alloc.c clock.c iget.c sys1.c sys2.c sys4.c
	 *	filsys.h ino.h proczomb.h systm.h user.h
	 *
	 */
/*
#define CBLOCK_16
	/*	Originally from UNSW
	 *
	 *	m40.s tty.c
	 *
	 *	Changes Cblock size to 16 bytes not 8
	 *	Reduces clist list manipulation.
	 */
/*
#define INIT_FIX
	/*
	 *	From UNSW system
	 *	Chris Maltby 	MARCH 77
	 *	Piers Lauder AUGUST 77
	 *
	 *	sys1.c
	 *
	 *	/etc/init (process one) only woken up when required.
	 *	Previously every process termination in the system woke
	 *	the init process.  This is only necessary if the parent
	 *	of the dying process is already dead.
	 *	The whole thing re-written using a single scan of the
	 *	proc array (up to 4 previously). MORE efficient.
	 *
	 *	Implemented at UKC by Peter C April 1978
	 */
/*
#define ZOMBIE 0
	/*
	 *	Chris Maltby	MARCH 77
	 *
	 *	sys1.c proc.h (proczomb.h at UKC) sys4.c sig.c slp.c clock.c
	 *
	 *	Several variables in the proc structure are used to store
	 *	post-mortem information about processes.  This avoids the swap
	 *	out & in of previous version for exit and wait. Process
	 *	terminations (exit & wait) go substantially faster.
	 *	Alternative process structure pz-* contains the definition of
	 *	the process area for dead processes. A few of the scheduling
	 *	routines have been altered so that no attempts are made
	 *	to alter the process area of 'dead'ns'.
	 *
	 *	Installed at UKC April 1978 Peter C
	 *	ifdefs removed 2/2/79
	 */
/* PROPER_TRAP - fix015 at UNSW
	 *		Greg Rose & Chris Maltby	UNSW
	 *
	 *		trap.c m40-45-70.s
	 *
	 *		make system do t bit tracing properly.
	 *		Rti's are done from all traps except
	 *		t or bpt traps.
	 */
/*
#define	MAX_PROC 0
	/*
	 *	Ian Johnstone	Jan '78
	 *
	 *	clock.c	sig.c	slp.c	sys1.c	sys4.c	proc.h
	 *
	 *	Keep track of which slot in the proc table is the last one
	 *	in use, and when searching the proc table only go up to maxproc
	 *	rather than &proc[NPROC].  This does speed things up a little.
	 *	Ken Thompson is also supposed to have found that the
	 *	system spends most of its time scanning the proc array.
	 *	For example ps is now many times faster less to transfer less to scan.
	 *	For example consider a system with NPROC=200 and 5 active processes
	 *	ZOMBIE defined - WITHOUT MAX_PROC time for executing wait was 1.18ms
	 *	- WITH MAX_PROC time for executing wait was 0.34ms - thus the benefits
	 *	are obvious in those parts of the system that search the proc table.
	 *	NOTE:	time == elapsed time == user time + system time
	 *	These values obtained on AGSM's 11/70
	 *	ifdefs removed 2/2/79
	 */
/*
#define EST_RW
	/*
	 *	From Ken Thompson Mods Issued to UNSW
	 *
	 *	Installed at UKC Feb 1979
	 *
	 *	main.c
	 *	sig.c sys1.c text.c seg.h
	 *
	 *	Re-write of estabur() to allow an extra parameter giving
	 *	Read write status for the text segment
	 *	sureg() also rewritten to be much smaller
	 */
/*
#define	LOWER_TEXT_SWAPS
       /*
	*	Chris Maltby	SEPTEMBER 77
	*
	*	slp.c subr.c text.c text.h rdwri.c - to read text segments
	*
	*	This alteration drastically reduces the number of swaps
	*	undertaken by UNIX. For example on Ian J's 11/70 swapping
	*	was reduced by about 85%. What more can I say !!
	*	When attaching to a shared text segment that was not
	*	already core resident the following procedure was
	*	followed:
	*		1. If in swap space goto 6
	*		2. Expand process size to enable read of
	*		   text from the a.out.
	*		3. Read text segment.
	*		4. Allocate swap space for text segment
	*		   and swap the segment out 
	*		5. Expand process size to USIZE.
	*		6. Swap out process!!
	*		7. Call sched.
	*	When the process is swapped back in to core
	*	all will magically be taken care of.
	*
	*	This is a little inefficient to say the least and
	*	47 % of all swaps counted were for 1024 bytes.
	*
	*	The new scheme:
	*		1. if in swap space goto 6
	*		2. Expand process size to enable read of
	*		   text from the a.out.
	*		3. Read text segment.
	*		4. Separate User Per Process area and text Segment
	*		   and install text segment in core. Mark it as not yet
	*		   swapped.
	*		5. Continue execution of process
	*		6. Swap in text segment.
	*		7. goto 5
	*	Note that only if required will the shared text segment now
	*	be swapped. It is now possible to run a shared
	*	text program that will cause no swapping if
	*	the program is not "sticky bit"ed.
	*
	*		AND all this only costs 98 bytes...
	*
	****
	*
	*	Totally new version obtained from Ken Thompson Mods
	*	does substantially the same as UNSW's version but will swap text
	*	and data separately.
	*	The mod requires EST_RW
	*/
/*
#define NEW_SCHED
	/*
	 *	Peter Collinson 1979 (From K. Thompson Mods)
	 *
	 *	slp.c
	 *	Various alterations to scheduling algorithms
	 *	1)	malloc now wakes up the scheduler when it frees store
	 *	2)	sched - rewritten to make it a bit more coherent
	 *		a)	swaps in processes depending on p_nice
	 *			as well as time swapped out
	 *		b)	swaps out processes depending on size as well as
	 *			time of store residency
	 */
/*
#define ORDER_BLOCKS
	/*
	 *	Peter Collinson 1978
	 *
	 *	bio.c and relevant disc drivers rk.c rp.c
	 *
	 *	Impose some ordering on the disc blocks presented to the
	 *	disc drivers
	 *	Two algorithms available:
	 *	1) Sort into ascending/descending order - define ASDES
	 *	2) Sort into ascending order only - do not define ASDES
	 *	   The second method is favourite currently!!
	 *	Modified March 1979 to allow swapping blocks to get
	 *	to the head of the q very quickly
	 */
/*
#define SETPRIBUG
	/*
	 *	Peter Collinson 29-Jan-79
	 *	(From K.Thompson Bell labs system release)
	 *
	 *	slp.c (clock.c - speculative mod)
	 *
	 *	The line 
	 *	if(p > curpri) in the routine setpri
 	 *	altered to
	 *	if(p < curpri)
	 *
	 *	On thinking this over - this may not be correct
	 *	See current version and clock.c alteration
	 *	Peter C - help from I.Johnstone UNSW
	 */
/*
#define SWAP_PANIC
	/*
	 *	Peter Collinson January 1979
	 *	From Ken Thompson mods
	 *
	 *	bio.c slp.c text.c
	 *
	 *	Panic on swap error moved to swap() in bio.c
	 *	removes a bit of superflous code from system
	 *
	 */
/*
 *	fix013 from UNSW
	/*
	 *	fio.c
	 *
	 *	Super-user can now change to zero mode directories
	 */
/*
#define UNLINK_PANIC
	/*
	 *	Peter Collinson - from K.Thompson Mods
	 *
	 *	sys4.c
	 *
	 *	Panic in unlink (Cannot happen) removed
	 */
/*
#define NEW_EXEC
	/*
	 *	Peter Collinson - from K.Thompson mods
	 *
	 *	sys1.c proc.h
	 *
	 *	Total re-write of exec system call to use a 
	 *	pseudo-file on the swap space to store
	 *	command strings (See QEXEC below)
	 *	Allows command strings of 5082 characters
	 *	The code is about 2 swapping clicks bigger
	 *	but it is much better than the old system
	 */
/*
#define SCHMAG_CHANGES
	/*
	 *	Peter Collinson - from K.Thompson Mods
	 *
	 *	clock.c
	 *
	 *	This is basically a new way of calculating process
	 *	priority.
	 *	p_cpu is incremented on every clock tick
	 *	and is adjusted every second by multiplying by a 
	 *	constant.
	 *	The algorithm appears to favour processes which
	 *	have low cpu usage (ie editor) and is thus fairer(?)
	 */

/*
#define MVDATA
	/*
	 *	Peter Collinson - September 1979
	 *
	 *	all *.h files - new file data.h
	 *
	 *	All data area definitions moved from the *.h files
	 *	to a new file data.h.
	 *	The new file is compiled with c.c (or equivalent)
	 *	so that actual data area definition only occurs in one
	 *	place. This makes it easier to alter sizes of various
	 *	table, since the sizes are not lurking in the object files
 	 *	param.h gives the names of the files which require
	 *	re-compilation for each variable
	 */



	/*
	 *
	 *
	 *
	 *	IFDEF'ed ALTERATIONS
	 *	IN GENERAL UNDEFINE THE NAME TO REMOVE THE CODE
	 *
	 *
	 *
	 */

#define	_1140 0
       /*
	*	clock.c param.h main.c rdwri.c subr.c
	*
	*	includes stuff specific to 40 cpu's.
	*/
/*
#define _1170
	/*
	 *	main.c clock.c bio.c rk.c rp.c
	 *
	 *	Include stuff specific to 70 cpu's
	 *	Currently undefined - for obvious reasons
	 */
/*
#define PROG_CLOCK
	/*
	 *	main.c
	 *
	 *	If defined includes code for a programmable clock
	 */
#define ERRLOG
	/*
	 *	Peter Collinson 1978
	 *
	 *	rp.c rk.c discerr.h (New header file)
	 *
	 *	Maintain block device hardware error logging in the unused
	 *	part of the root super block - this is an attempt to aviod
	 *	writing error information on a failing drive and thereby
	 *	compounding the error.
	 *	On the first error in a sequence of re-tries the entire
	 *	hardware interface with the block device is written into
	 *	the super block, this should hopefully provide the most
	 *	useful information
	 */
#define	RAW_BUFFER_POOL 0
#define	NRAWBUFS	6
       /*
	*	Ian Johnstone	SEPTEMBER 77
	*
	*	bio.c and others disk/tape raw i/o interfaces as reqd.
	*
	*	In order to improve system performance allocate 'NRAWBUFS'
	*	buffer headers - these headers to be used for swapping and
	*	general raw i/o. Instead if using 'swbuf' for all swap
	*	i/o in the system, allocate from the raw buffer pool.
	*	If 'physio' is passed a null buffer pointer then
	*	it will allocate a buffer for the i/o and free it on completion
	*	of the i/o.  Current raw i/o interfaces then do not have to be
	*	altered unless desired.  The main benefit to these interfaces
	*	will be that on multiple devices overlapped seeks will
	*	possible, also ordered queueing of raw
	*	i/o requests can also be done. (assuming a clever driver)
	*	Improves swapping.  'NRAWBUFS' should be 2 greater
	*	than the expected number of simultaneous raw i/o operations
	*	to prevent lockout of swap i/o.
	*
 	*	At UKC to save code old code for actual raw buffers is disabled
	*/
#define	BETTER_TIME 0
       /*
	*	Ian Johnstone & Andrew Hume SEPTEMBER 76
	*
	*	alloc.c
	*
	*	update() always updates on root file system super block.
	*	After booting time more likely to be correct.  Also allows
	*	knowledge of when a system crashed to within 30 seconds.
	*	Omitting to set date at BOOT of system less likley
	*	to cause havoc with incremental dumps.
	*	Requires icheck to be modified
	*	last sync() call in makefree(file) needs removing
	*/
#define MEMPARITY 0
	/*
	 *	Peter Collinson MAY 1978
	 *
	 *	main.c trap.c
	 *	New file in dmr: parity.c
	 *
	 *	Enable memory parity (11/40's only?) and set up trap routine to panic if
	 *	parity fail occurs
	 */
/*
#define	LRU_INODE 0
	/*
	 *	UNKNOWN HACKER -- university of toronto
	 *	Improved debugged installed UNSW Ian Johnstone Jan 78
	 *
	 *	inode.h	iget.c	clock.c	sys3.c	sys4.c
	 *
	 *	Incore inode structures are allocated on an LRU basis, and
	 *	if a requested Inode is still in core, it is not read in
	 *	again.  This seems to dramatically speed up pathname
	 *	searches, which do an awful lot of iget's and iput's.
	 *	For example a stat of a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a/a
	 *	previously took 1.1 seconds (avg) per call this change
	 *	reduces this to 0.07 seconds (avg) !!!!
	 *	These tests carried out on AGSM 11/70 (1 RP04)
	 *
	 *	By the way: LRU stands for Least Recently Used I think.
	 */
#define WAITABAN 0
	/*
	 *	Peter Collinson January 1979
	 *	(From K.Thompson's system release )
	 *
	 *	proc.h slp.c sig.c
	 *
	 *	WAIT state for processes abandoned - SSLEEP state does instead
	 *	re-write of sleep is much tidier
	 */
#define ctos(x) ((x+127)>>7)
#define nseg(x) ctos(x)
#define ctob(x) ((x+7)>>3)
	/*
	 *	Peter Collinson January 1979
	 *	From Ken Thompson changes
	 *
	 *	main.c sys1.c text.c
	 *
	 *	Macros for units conversion
	 *	ctos - core clicks (64 bytes) to segments
	 *		replaces nseg
	 *	ctob - core clicks (64 bytes) to blocks
	 *	This mod saves bytes!!
	 */
#define MAXMIN 0
struct
{	unsigned	m_unsign;	};
#define min(a, b) (a.m_unsign < b ? a : b)
#define max(a, b) (a.m_unsign > b? a : b)
	/*
	 *	Peter Collinson Feb 1979
	 *
	 *	define the statements above to replace the two
	 *	routines in rdwri.c
	 *	Requires the new compiler for type conversion - also saves bytes
	 */
#define PIPEFIX 0
	/*
	 * 	Peter Collinson January 1979
	 *	From K.Thompson source
	 *
	 *	pipe.c
	 *
	 *	Alteration to readp()
	 *	to stop certain race conditions
	 */
#define B_AGE 0
	/*
	 *	Peter Collinson
	 *	from UNSW & K.Thompson mods
	 *
	 *	buf.h bio.c
	 *
	 *	Allow proper handling of write behind block on
	 *	freelist. Put at head of free queue those blocks
	 *	that have to be written
	 */
/*
#define ACCT	0
	/*
	 *	Peter Collinson Feb 1979
	 *	From K.Thompson Mods
	 *
	 *	user.h systm.h clock.c acct.c sysent.c sys1.c
	 *
	 *	Introduce proper process accounting
	 *	has a new system call
	 *	sys 51.; 0	turns accounting off
	 *	sys 51.; "file name" turns accounting on using the
	 *		named file
	 *	Modified from original version to perform less writing
	 *	Buffers information for accounting into a disc block buffer
	 *	obtained for the purpose - this buffer contains 16 entries
	 *	It is written out by the normal writing mechanism
	 */
/*
#define ACTMON 040
	/*
	 *	Peter Collinson UKC
	 *
	 *	rp.c
	 *
	 *	Monitor activity on rp discs
	 *
	 *	writes the disc block number read or written
	 *	onto rk drive 1 - no file system on the data
	 *	disc - it is just treated as a sequence of blocks
	 *	This is currently de-activated but the code is still
	 *	there if needs be
	 */
#define QEXEC
	/*
	 *	Peter Collinson - a genuine original contribution
	 *
	 *	sys1.c
	 *	
	 *	Places the first 16 characters of an exec call
	 *	in u.u_comm 
	 *	this saves disc activity on small execs
	 *	Nov 1979
	 *	Moved to put first 50 characters in u.u_fsav
	 */
#define NEW_SLEEP
	/*
	 *	Peter Collinson April 1979
	 *
	 *	clock.c sys2.c proc.h (ps.c)
	 *
	 *	Implement new system calls 
	 *	Alarm - send signal 14 after n secs
	 *	pause - indefinate wait
	 *	Cant be v6+ numbers because terms is in way
	 *
	 *
	 *	Also change the sleep call so that it uses the
	 *	alarm mechanism
	 */

#define TELL
	/*
	 *	Peter Collinson July 1979
	 *	from Ken Thompson System Mods
	 *
	 *	sysent.c, sys2.c
	 *
	 *	Implement tell system call - required by 
	 *	standard I/O library
	 */
