/* RWDOCS */
/* filename	: profile.c
 * purpose	: a function used to record profile data
 * author	: Randy Wright
 *		 ((C)) Copyright 1994 Randy Wright
 *
 * Output goes to file prof.out, which can be interpreted
 * by profdump.
 *
 *
 * this file is copyright and not public domain. anyone
 * may copy this file, redistribute it and store it in any
 * medium they see fit provided they do not charge for the
 * "content" of this file and they do not remove this notice
 * or the copyright notice.
 * 
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <sys/types.h>

struct prof_rec  {
	time_t tt;	/* time of record */
	int ln;		/* line number */
	char fn[40];	/* filename */
} prof_rec ;

static int prof_fd = -1;	/* the file to write */
static int mzfd;		/* the mz device driver is used to deliver
			         * time in ticks, with ioctl(fd,2,&time_t) */
/* open ./prof.out for writing and /dev/memquery to access mz driver. */
void
open_profile()
{
/* RWDOCE */
	printf( "profiling open\n" );

	if((prof_fd = creat( "prof.out", O_WRONLY ))  == -1 )	{
		fprintf( stderr, "can't open prof.out\n" );
	}
	
	if( (mzfd = open( "/dev/memquery", O_RDONLY)) == -1 )	{
		fprintf( stderr, "can't open /dev/memquery\n" );
	}
	return;
}

/* RWDOCS */
/* close ./prof.out and /dev/memquery */
void
close_profile()
{
/* RWDOCE */
	int close();

	if( prof_fd != -1 )  {
		close( prof_fd );
		prof_fd = -1;
		close( mzfd );
	}

}

/* RWDOCS */
/* make a record in file prof.out. records
 * can be interpreted by profdump.
 * call to profile will typically be:
 * profile( __LINE__ , __FILE__ );
 *
 * This call can be placed at entry point and exit points
 * of each function.
 *
 * profile function will obtain current lbolt tick value
 * from kernel through mz device driver and record that
 * along with line number and filename in order to
 * give a 1/100th of a second accuracy profile of
 * program execution.
 *
 */
void
profile( line, f )
int line;
char * f;
{

/* RWDOCE */
	int  ioctl(), write(), close();
	if( prof_fd == -1 ) return;

	ioctl( mzfd, 2, &prof_rec.tt ); /* get the time in ticks */
	prof_rec.ln = line;		/* the line number in the file */
	strncpy( prof_rec.fn, f, 40 );	/* the filename */
	
	if( (write(prof_fd, &prof_rec, sizeof( prof_rec ))) != sizeof( prof_rec ) ){
		fprintf( stderr, "bad write in profile\n" );
		close( prof_fd );
		prof_fd = -1;
	}
	return;
}

/* end of profile.c */
