/* filename	: profdump.c
 * purpose	: a program used to display profile data
 * author	: Randy Wright
 *		  ((C)) Copyright 1994 Randy Wright
 *
 * this file is copyright and not public domain. anyone
 * may copy this file, redistribute it and store it in any
 * medium they see fit provided they do not charge for the
 * "content" of this file and they do not remove this notice
 * or the copyright notice.
 * 
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <sys/types.h>

struct prof_rec  {
	time_t tt;	/* time of record */
	int ln;		/* line number */
	char fn[40];	/* filename */
} prof_rec ;

static int prof_fd = -1;	/* the file to write */
int page = 1;

main( argc, argv)
int argc;
char **argv;
{
int totrecs, currec, fd, i;
unsigned long end, spot;

char inbuf[40];

if( argc > 1 )
	{
	argv;
	page = 0;
	}



if( (fd = open( "prof.out", O_RDONLY )) == -1 )
	{
	printf( "can't open prof.out\n" );
	exit(1);
	}

end = lseek( fd, 0L, SEEK_END );
totrecs = end / sizeof( prof_rec );
lseek( fd, 0L, SEEK_SET );

fprintf(stderr, "-- profdump -- totrecs:%d\n", totrecs );

	/* main loop to step thru all records */
for( currec = 0; currec < totrecs;  )
	{
		/* pager loop */
	for ( i = 0; i < 20; i++, currec++ )
		{
	if( (read(fd, &prof_rec, sizeof( prof_rec) )) == sizeof( prof_rec ) )	
	printf( "%s:%06d\t%d  [%d]\n", prof_rec.fn, prof_rec.ln, prof_rec.tt, currec );
		}

	if( page )
		{
			/* prompt */
		printf( "tot[%d] ---- q,<enter> or recnumber ---\n", totrecs );
		if( (fgets( inbuf, 40, stdin )) == NULL )
			{
			printf( "end\n" );
			exit(1);
			}
	
		if( inbuf[0] == 'q' ) exit(0);
		if( inbuf[0] == '\n' ) continue;
		else
			{
			currec = atoi( inbuf );
			spot = currec * sizeof( prof_rec );
			if( (lseek( fd, spot, SEEK_SET )) == -1)
				{
				printf( "bad seek\n" );
				exit(1);
				}
			}
		} /* if page */
		else fprintf( stderr, "%d  \r", currec );
	} /* main looop */

printf( "-- end --\n" );
exit(0);

}


