/* RWDOCS */
#ifndef MBUF_H
#define MBUF_H
/* filename	: mbuf.h
 * purpose	: structs and constants for mbufs
 */

/* Basic message buffer structure */
struct mbuf {
	struct mbuf *next;	/* Links mbufs belonging to single packets */
	struct mbuf *anext;	/* Links packets on queues */
	int32 size;				/* Size of associated data buffer */
	int refcnt;				/* Reference count */
	struct mbuf *dup;    /* Pointer to duplicated mbuf */
	char *data;				/* Active working pointers */
	int32 cnt;
};
#define	NULLBUF	(struct mbuf *)0
#define	NULLBUFP (struct mbuf **)0

#ifdef GCC
	/* from mbuf.c */
struct mbuf *alloc_mbuf(int32 size);
struct mbuf *free_mbuf(struct mbuf *bp);
struct mbuf *free_p(struct mbuf *bp);
void free_q(struct mbuf **q);
int32 len_mbuf(struct mbuf *bp);
int32 len_q(struct mbuf *bp);
void trim_mbuf(struct mbuf **bpp,int32 length);
int32 dup_p(struct mbuf **hp,struct mbuf *bp,int32 offset,int32 cnt);
struct mbuf *copy_p(struct mbuf *bp,int32 cnt);
int32 pullup(struct mbuf **bph,char *buf,int32 cnt);
void append(struct mbuf **bph,struct mbuf *bp);
struct mbuf *pushdown(struct mbuf *bp,int32 size);
void enqueue(struct mbuf **q,struct mbuf *bp);
struct mbuf *dequeue(struct mbuf **q);
struct mbuf *qdata(char *data,int32 cnt);
int32 dqdata(struct mbuf *bp,char *buf,int32 cnt);
int32 pull32(struct mbuf **bpp);
int32 pull16(struct mbuf **bpp);
int32 pullchar(struct mbuf **bpp);
char *put32(char *cp,int32 x);
char *put16(char *cp,int32 x);


#else
struct mbuf *alloc_mbuf(), *free_mbuf(), *free_p(), *copy_p(),
	*pushdown(), *dequeue(), *qdata();
void free_q(), trim_mbuf(), append(), enqueue();
int32 len_mbuf(), len_q(), dup_p(), pullup(), dqdata(), 
	pull32(), pull16(), pullchar();
char *put32(), *put16();
#endif /* GCC */

void hex_dump(),ascii_dump();

#define	AUDIT(bp)	audit(bp,__FILE__,__LINE__)

#endif /* MBUF_H */
/* RWDOCE */

