/* RWDOCS */
/* filename	: ip.h
 * purpose	: constants and definitions for ip
 * note-- function protos, internal date redefined
 * for 32 bit environment, Jan 1994 RLW --
 *
 */

#ifndef IP_H
#define IP_H
#include "timer.h"
	/* for struct pseudo_header */
#include "internet.h"
#define	NROUTE	5	/* Number of hash chains in routing table */

extern int32 ip_addr;	/* Our IP address for ICMP and source routing */

extern int32 ip_ttl;	/* Default time-to-live for IP datagrams */

#define	IPVERSION	4
/* IP header, INTERNAL representation */
struct ip {
	int32 version;		/* IP version number */
	int32 tos;		/* Type of service */
	int32 length;		/* Total length */
/* ----- */
	int32 id;		/* Identification */
	int32 fl_offs;		/* Flags + fragment offset */

#define	F_OFFSET	0x1fff	/* Offset field */
#define	DF	0x4000		/* Don't fragment flag */
#define	MF	0x2000		/* More Fragments flag */	

/* ----- */
	int32 source;		/* Source address */
	int32 dest;		/* Destination address */
/* ----- */
	char options[44];	/* Options field */
/* ----- */
	int32 optlen;		/* Length of options field, bytes */
	int32 ttl;		/* Time to live */
	int32 protocol;		/* Protocol */
/* ----- */
};
#define	NULLIP	(struct ip *)0
#define	IPLEN	20	/* Length of standard IP header */

/* Fields in option type byte */
#define	OPT_COPIED	0x80	/* Copied-on-fragmentation flag */
#define	OPT_CLASS	0x60	/* Option class */
#define	OPT_NUMBER	0x1f	/* Option number */

/* IP option numbers */
#define	IP_EOL		0	/* End of options list */
#define	IP_NOOP		1	/* No Operation */
#define	IP_SECURITY	2	/* Security parameters */
#define	IP_LSROUTE	3	/* Loose Source Routing */
#define	IP_TIMESTAMP	4	/* Internet Timestamp */
#define	IP_RROUTE	7	/* Record Route */
#define	IP_STREAMID	8	/* Stream ID */
#define	IP_SSROUTE	9	/* Strict Source Routing */

/* Timestamp option flags */
#define	TS_ONLY		0	/* Time stamps only */
#define	TS_ADDRESS	1	/* Addresses + Time stamps */
#define	TS_PRESPEC	3	/* Prespecified addresses only */

/* IP routing table entry */
struct route {
	struct route *prev;	/* Linked list pointers */
	struct route *next;
	int32 target;		/* Target IP address */
	int32 gateway;		/* IP address of local gateway for this target */
	int32 metric;		/* Hop count, whatever */
	struct interface *interface;	/* Device interface structure */
};
#define	NULLROUTE	(struct route *)0
extern struct route *routes[32][NROUTE];	/* Routing table */
extern struct route r_default;			/* Default route entry */

/* Cache for the last-used routing entry, speeds up the common case where
 * we handle a burst of packets to the same destination
 */
struct rt_cache {
	int32 target;
	struct route *route;
};
extern struct rt_cache rt_cache;

/* Reassembly descriptor */
struct reasm {
	struct reasm *next;	/* Linked list pointers */
	struct reasm *prev;
	int32 source;		/* These four fields uniquely describe a datagram */
	int32 dest;

	int32 id;
	int32 protocol;

	int32 length;		/* Entire datagram length, if known */
	struct timer timer;	/* Reassembly timeout timer */
	struct frag *fraglist;	/* Head of data fragment chain */
};

#define	NULLREASM	(struct reasm *)0

/* Fragment descriptor in a reassembly list */
struct frag {
	struct frag *prev;	/* Previous fragment on list */
	struct frag *next;	/* Next fragment */
	struct mbuf *buf;	/* Actual fragment data */
	int32 offset;		/* Starting offset of fragment */
	int32 last;		/* Ending offset of fragment */
};
#define	NULLFRAG	(struct frag *)0

extern struct reasm *reasmq;	/* The list of reassembly descriptors */

/* IP error logging counters */
struct ip_stats {
	long total;		/* Total packets received */
	unsigned runt;		/* Smaller than minimum size */
	unsigned length;	/* IP header length field too small */
	unsigned version;	/* Wrong IP version */
	int32 checksum;	/* IP header checksum errors */
	unsigned badproto;	/* Unsupported protocol */
};

#ifdef GCC
	/* ip.c */
void ip_recv(struct ip *ip,struct mbuf *bp,int rxbroadcast);
int ip_send(int32 source,int32 dest,int32 protocol,int32 tos,
	int32 ttl,struct mbuf *bp,int32 length,int32 id,int32 df);
struct mbuf * fraghandle(struct ip *ip,struct mbuf *bp);
struct reasm * lookup_reasm(struct ip *ip);
struct reasm * creat_reasm(struct ip *ip);
void free_reasm(struct reasm *rp);
void ip_timeout(int *arg);
struct frag * newfrag(int offset,int last,struct mbuf *bp);
void freefrag(struct frag *fp);
	/* iproute.c */
int ip_route(struct mbuf *bp,int rxbroadcast);
int rt_add(int32 target,unsigned int bits,int32 gateway,int metric,struct interface *interface);
int rt_drop(int32 target,unsigned int bits);
int hash_ip(int32 addr);
int32 ip_mtu(int32 addr);
struct route * rt_lookup(int32 target);
struct mbuf * htonip(struct ip *ip,struct mbuf *data);
int32 ntohip(struct ip *ip,struct mbuf **bpp);
int32 eac(int32 sum);
int32 cksum(struct pseudo_header *ph,struct mbuf *m,int32 len);
int32 get32(char *cp);

#else
	/* ip.c */
void ip_recv(), free_reasm(), ip_timeout(), freefrag();
int ip_send();
struct mbuf * fraghandle();
struct reasm * lookup_reasm(), * creat_reasm();
struct frag * newfrag();

	/* iproute.c */
int ip_route(), rt_add(), rt_drop(), hash_ip();
int32 eac(), cksum(), get32(), ip_mtu(), ntohip();

struct route * rt_lookup();
struct mbuf * htonip();

#endif /* GCC */
extern struct ip_stats ip_stats;

#endif /* IP_H */
/* RWDOCE */
