# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iotoperations.aio import IoTOperationsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIoTOperationsMgmtDataflowOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IoTOperationsMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dataflow_get(self, resource_group):
        response = await self.client.dataflow.get(
            resource_group_name=resource_group.name,
            instance_name="str",
            dataflow_profile_name="str",
            dataflow_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dataflow_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.dataflow.begin_create_or_update(
                resource_group_name=resource_group.name,
                instance_name="str",
                dataflow_profile_name="str",
                dataflow_name="str",
                resource={
                    "extendedLocation": {"name": "str", "type": "str"},
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "operations": [
                            {
                                "operationType": "str",
                                "builtInTransformationSettings": {
                                    "datasets": [
                                        {
                                            "inputs": ["str"],
                                            "key": "str",
                                            "description": "str",
                                            "expression": "str",
                                            "schemaRef": "str",
                                        }
                                    ],
                                    "filter": [
                                        {"expression": "str", "inputs": ["str"], "description": "str", "type": "str"}
                                    ],
                                    "map": [
                                        {
                                            "inputs": ["str"],
                                            "output": "str",
                                            "description": "str",
                                            "expression": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "schemaRef": "str",
                                    "serializationFormat": "str",
                                },
                                "destinationSettings": {"dataDestination": "str", "endpointRef": "str"},
                                "name": "str",
                                "sourceSettings": {
                                    "dataSources": ["str"],
                                    "endpointRef": "str",
                                    "assetRef": "str",
                                    "schemaRef": "str",
                                    "serializationFormat": "str",
                                },
                            }
                        ],
                        "mode": "str",
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dataflow_begin_delete(self, resource_group):
        response = await (
            await self.client.dataflow.begin_delete(
                resource_group_name=resource_group.name,
                instance_name="str",
                dataflow_profile_name="str",
                dataflow_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dataflow_list_by_resource_group(self, resource_group):
        response = self.client.dataflow.list_by_resource_group(
            resource_group_name=resource_group.name,
            instance_name="str",
            dataflow_profile_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
