Set up 
  $ . $TESTDIR/setup.sh

Set up the executable: samFilter.
  $ EXEC=$TESTDIR/../samFilter

#Test samFilter with a *.sam file generated by blasr
  $ OUTFILE=$OUTDIR/lambda_bax_filter_1.sam
  $ STDFILE=$STDDIR/lambda_bax_filter_1.sam
  $ TMP1=$OUTDIR/$$.tmp.out 
  $ TMP2=$OUTDIR/$$.tmp.stdout 

  $ rm -f $OUTFILE
  $ $EXEC $DATDIR/lambda_bax.sam $DATDIR/lambda_ref.fasta $OUTFILE --minAccuracy 70 --minPctSimilarity 30 --hitPolicy all
  $ tail -n+7 $OUTFILE |sort > $TMP1 
  $ tail -n+7 $STDFILE |sort > $TMP2 
  $ diff $TMP1 $TMP2 
  $ rm $TMP1 $TMP2 

#Test whether --minAccuracy and --minPctSimilarity can be float.
#  $ rm -f $OUTFILE
#  $ $EXEC $DATDIR/lambda_bax.sam $DATDIR/lambda_ref.fasta $OUTFILE --minAccuracy 70.0 --minPctSimilarity 30.0 --hitPolicy all
#  $ tail -n+7 $OUTFILE | sort > $TMP1 
#  $ tail -n+7 $STDFILE | sort > $TMP2 
#  $ diff $TMP1 $TMP2 
#  $ rm $TMP1 $TMP2 

#Test samFilter with -hitPolicy allbest
  $ OUTFILE=$OUTDIR/lambda_bax_filter_2.sam
  $ STDFILE=$STDDIR/lambda_bax_filter_2.sam

  $ rm -f $OUTFILE
  $ $EXEC $DATDIR/lambda_bax.sam $DATDIR/lambda_ref.fasta $OUTFILE --hitPolicy allbest
  $ tail -n+7 $OUTFILE > $TMP1 
  $ tail -n+7 $STDFILE > $TMP2 
  $ diff $TMP1 $TMP2 
  $ rm $TMP1 $TMP2 

#Test samFilter with --hitPolicy random   
  $ OUTFILE=$OUTDIR/lambda_bax_filter_3.sam
  $ STDFILE=$STDDIR/lambda_bax_filter_3.sam

  $ rm -f $OUTFILE
  $ $EXEC $DATDIR/lambda_bax.sam $DATDIR/lambda_ref.fasta $OUTFILE --hitPolicy random
  $ tail -n+7 $OUTFILE > $TMP1 
  $ tail -n+7 $STDFILE > $TMP2 
  $ diff $TMP1 $TMP2 
  $ rm $TMP1 $TMP2 

#Test samFilter with --hitPolicy randombest   
  $ OUTFILE=$OUTDIR/lambda_bax_filter_4.sam
  $ STDFILE=$STDDIR/lambda_bax_filter_4.sam

  $ rm -f $OUTFILE
  $ $EXEC $DATDIR/lambda_bax.sam $DATDIR/lambda_ref.fasta $OUTFILE --hitPolicy randombest 
  $ tail -n+7 $OUTFILE > $TMP1 
  $ tail -n+7 $STDFILE > $TMP2 
  $ diff $TMP1 $TMP2 
  $ rm $TMP1 $TMP2 


# Test samFilter with --hitPolicy leftmost
  $ OUTFILE=$OUTDIR/test_leftmost_out.sam

  $ rm -f $OUTFILE
  $ $EXEC $DATDIR/test_leftmost.sam $DATDIR/test_leftmost_target.fasta $OUTFILE --hitPolicy leftmost 
  $ tail -n+6 $OUTFILE |cut -f 4 
  1

  $ OUTFILE=$OUTDIR/lambda_bax_filter_5.sam
  $ STDFILE=$STDDIR/lambda_bax_filter_5.sam

  $ rm -f $OUTFILE
  $ $EXEC $DATDIR/lambda_bax.sam $DATDIR/lambda_ref.fasta $OUTFILE 
  $ tail -n+7 $OUTFILE > $TMP1 
  $ tail -n+7 $STDFILE > $TMP2 
  $ diff $TMP1 $TMP2 
  $ rm $TMP1 $TMP2 

#Test samFilter with --holeNumbers
  $ OUTFILE=$OUTDIR/lambda_bax_filter_6.sam
  $ STDFILE=$STDDIR/lambda_bax_filter_6.sam

  $ rm -f $OUTFILE
  $ $EXEC $DATDIR/lambda_bax.sam $DATDIR/lambda_ref.fasta $OUTFILE --holeNumbers 101350-105000,21494 
  $ tail -n+7 $OUTFILE > $TMP1 
  $ tail -n+7 $STDFILE > $TMP2 
  $ diff $TMP1 $TMP2 
  $ rm $TMP1 $TMP2 

#Test samFilter with -filterAdapterOnly
  $ $EXEC $DATDIR/filterAdapterOnly.sam $DATDIR/references/H1_6_Scal_6x/sequence/H1_6_Scal_6x.fasta $OUTDIR/filterAdapterOnly.sam -filterAdapterOnly $DATDIR/references/H1_6_Scal_6x/annotations/H1_6_Scal_6x_adapters.gff
  $ tail -n+6 $OUTDIR/filterAdapterOnly.sam |cut -f 1,2,3,4
  m130302_124313_42130_c100502672550000001523078308081365_s1_p0/10817\t16\t11k_plasmidbell_H1_6_Scal_6x\t29466 (esc)

