/*
 * xt_frame.c,
 *
 * Copyright (C) 1997 Rasca Gmelch, Berlin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * This file contains routines for setting up and handling the selection
 * rectangle. Both Xt and GTK2 versions are in here now.
 *
 */

#include "../config.h" //autoconf output
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include "Xw/Toggle.h"
#include "Xw/Label.h"
#include "frame.h"
#include "xt_frame.h"
#include "app_data.h"
#include "job.h"

/*
 * some globals
 */
static Widget
top, left, right, bottom, blind = None;
extern XRectangle XVC_frame_rectangle;
extern int XVC_frame_lock;
extern Widget toplevel;


/*
 * XVIDCAP API STUFF
 *
 * XVC_CREATEFRAME SETS UP THE FRAME ... THE REST IS DONE BY THE GUI CALLBACKS
 * CAN BE FOUND IN CONTROL.H ... OR XT_CONTROL.C
 *
 */


/*
 * CALLBACKS
 *
 */

/*
 * event handler
 * handle the capture frame, e.g. move, unmap, etc.
 */
void
MoveFrameEH(Widget parent, XtPointer xtp, XEvent *ev, Boolean *boo) {
    Position x, y;
    Dimension pheight;
    #ifdef DEBUG
    printf("MoveFrameEH() event type = %d\n", ev->type);
    #endif
    if (ev->type == ConfigureNotify) {
        if (!XVC_frame_lock) {
            /* ignore it
             */
            return;
        }
        XtVaGetValues(parent,
        XtNx, &x,
        XtNy, &y,
        XtNheight, &pheight,
        NULL);
        y += pheight + FRAME_OFFSET;
        ChangeFrame(x, y, XVC_frame_rectangle.width, XVC_frame_rectangle.height, FALSE);
    } else if ( ev->type == UnmapNotify ) {
        XtUnmanageChild(top);
        XtUnmanageChild(bottom);
        XtUnmanageChild(left);
        XtUnmanageChild(right);
        if (blind)
            XtUnmanageChild(blind);
    } else if ( ev->type == MapNotify ) {
        XtManageChild(top);
        XtManageChild(bottom);
        XtManageChild(left);
        XtManageChild(right);
        if (blind)
            XtManageChild(blind);
    } else if ( ev->type == FocusIn ) {
        XRaiseWindow(XtDisplay(top), XtWindow(top));
        XRaiseWindow(XtDisplay(top), XtWindow(bottom));
        XRaiseWindow(XtDisplay(top), XtWindow(left));
        XRaiseWindow(XtDisplay(top), XtWindow(right));
        if (blind)
            XRaiseWindow(XtDisplay(top), XtWindow(blind));
    }
}



/*
 * HELPER FUNCTIONS
 *
 */

/*
 * change the position and the dimension of the capture frame
 */
void
ChangeFrame(int x, int y, int width, int height, Boolean reposition_control) {
    int frame_width = FRAME_WIDTH;
    int max_width, max_height;
    Window topwin, ignore;
    int pwidth, pheight, px, py, pborder_width, pdepth;
    Display *dpy;
    
    Job *job = job_ptr();
    
    if ( ! (job->flags & FLG_NOGUI ) ) {
        dpy = XtDisplay(toplevel);
        max_width = WidthOfScreen(XtScreen(top));
        max_height= HeightOfScreen(XtScreen(top));
    } else {
        dpy = XOpenDisplay(NULL);
        max_width = WidthOfScreen(DefaultScreenOfDisplay(dpy));
        max_height = HeightOfScreen(DefaultScreenOfDisplay(dpy));
    } 
    
    /* we have to adjust it to viewable areas
     */
    #ifdef DEBUG
    printf("ChangeFrame() screen = %dx%d selection=%dx%d\n",
    max_width, max_height, width, height);
    #endif
    if (x < 0)
        x = 0;
    if (width > max_width)
        width = max_width;
    if (x + width > max_width)
        x = max_width - width;
    
    if (height > max_height)
        height = max_height;
    if (y + height > max_height)
        y = max_height - height;
    if (y < 0)
        y = 0;
    
    if ( ! ( job->flags & FLG_NOGUI ) ) {
        XtVaSetValues(top,
        XtNx, x - frame_width,
        XtNy, y - frame_width,
        XtNwidth, width + 2 * frame_width,
        XtNheight, frame_width,
        NULL);
        XtVaSetValues(bottom,
        XtNx, x - frame_width,
        XtNy, y + height,
        XtNwidth, width + 2 * frame_width,
        XtNheight, frame_width,
        NULL);
        XtVaSetValues(left,
        XtNx, x - frame_width,
        XtNy, y - frame_width,
        XtNwidth, frame_width,
        XtNheight, height + 2 * frame_width,
        NULL);
        XtVaSetValues(right,
        XtNx, x + width,
        XtNy, y - frame_width,
        XtNwidth, frame_width,
        XtNheight, height + 2 * frame_width,
        NULL);
        if (blind)
            XtVaSetValues(blind,
            XtNx, x,
            XtNy, y,
            XtNwidth, width,
            XtNheight, height,
            NULL);
    }
    XVC_frame_rectangle.x = x;
    XVC_frame_rectangle.y = y;
    XVC_frame_rectangle.width = width;
    XVC_frame_rectangle.height= height;
    
    if (!IsFrameLocked() && ( ! (job->flags & FLG_NOGUI)) && reposition_control ) {
        topwin = XtWindow( toplevel );
        XGetGeometry(dpy, topwin, &ignore, &px, &py, &pwidth, &pheight, &pborder_width,
        &pdepth);
        pwidth += FRAME_OFFSET;
        pheight += FRAME_OFFSET;
        
        if ( ( y - pheight - 30 ) >= 0 ) {
            // FIXME: find out how to determine the title bar height, if possible
            // don*t know real title bar height ...
            // If I knew, I perhaps didn*t absolutely need to unlock the frame
            // if a position is given ...
            XtVaSetValues(toplevel, XtNx, x, XtNy, ( y - pheight - 30 ), NULL);
        } else {
            if ( ( y + pheight + height ) < max_height ) {
                XtVaSetValues(toplevel, XtNx, x, XtNy, ( y + height + FRAME_OFFSET ), NULL);
            } else {
                if ( x > pwidth ) {
                    XtVaSetValues(toplevel, XtNx, ( x - pwidth), XtNy, y, NULL);
                } else {
                    if ( ( x + width + pwidth ) < max_width ) {
                        XtVaSetValues(toplevel, XtNx, ( x + width + FRAME_OFFSET ), XtNy, y, NULL);
                    }
                    // ansonsten lass das GUI wo es ist ...
                }
            }
        }
    }
    if ( job->flags & FLG_NOGUI ) {
        XCloseDisplay(dpy);
    } 
    
}

/*
 * create the video frame
 */
void
CreateFrame(Widget parent, int width, int height, int flags) {
    Position x, y;
    Dimension pwidth, pheight;
    XVC_frame_lock = 1;
    
    #ifdef DEBUG
    printf("CreateFrame() %d %d\n", width, height);
    #endif
    XtVaGetValues(parent, XtNx, &x, XtNy, &y, XtNwidth, &pwidth, XtNheight, &pheight, NULL);
    if (x < 0)
        x = 0;
    y += pheight + FRAME_OFFSET;
    if (y < 0)
        y = 0;
    XVC_frame_rectangle.width = width;
    XVC_frame_rectangle.height= height;
    XVC_frame_rectangle.x = x;
    XVC_frame_rectangle.y = y;
    
    if ( ! ( flags & FLG_NOGUI ) ) {
        top = XtVaCreatePopupShell("top", overrideShellWidgetClass, parent,
        XtNx, x-FRAME_WIDTH,
        XtNy, y-FRAME_WIDTH,
        XtNwidth, width+2*FRAME_WIDTH,
        XtNheight, FRAME_WIDTH,
        NULL);
        bottom = XtVaCreatePopupShell("bottom", overrideShellWidgetClass, parent,
        XtNx, x-FRAME_WIDTH,
        XtNy, y+height,
        XtNwidth, width+2*FRAME_WIDTH,
        XtNheight, FRAME_WIDTH,
        NULL);
        left= XtVaCreatePopupShell("left", overrideShellWidgetClass, parent,
        XtNx, x-FRAME_WIDTH,
        XtNy, y-FRAME_WIDTH,
        XtNwidth, FRAME_WIDTH,
        XtNheight, height+2*FRAME_WIDTH,
        NULL);
        right= XtVaCreatePopupShell("right", overrideShellWidgetClass, parent,
        XtNx, x+width,
        XtNy, y-FRAME_WIDTH,
        XtNwidth, FRAME_WIDTH,
        XtNheight, height+2*FRAME_WIDTH,
        NULL);
        if (flags & FLG_USE_V4L) {
            blind = XtVaCreatePopupShell("blind", overrideShellWidgetClass, parent,
            XtNx, x+FRAME_WIDTH,
            XtNy, y+FRAME_WIDTH,
            XtNwidth, width,
            XtNheight, height,
            NULL);
            XtVaCreateManagedWidget("text", xwLabelWidgetClass, blind,
            XtNlabel, "Source: Video4Linux", NULL);
            XtPopup(blind, XtGrabNone);
        }
        
        XtPopup(top, XtGrabNone);
        XtPopup(bottom, XtGrabNone);
        XtPopup(left, XtGrabNone);
        XtPopup(right, XtGrabNone);
        XtAddEventHandler(parent,
        StructureNotifyMask|FocusChangeMask|ExposureMask,
        False, MoveFrameEH, NULL);
    }
}


