/*
 * job.h
 *
 * Copyright (C) 1997-98 Rasca, Berlin
 * Copyright (C) 2003,04 Karl, Frankfurt
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <X11/Intrinsic.h>

#ifndef _JOB_H_
#define _JOB_H_

/*
 */
typedef struct _Job {
	float fps;			/* frames per second */
	char *file;			/* filename */
	int flags;			/* different flags .. see app_data.h */
	int state;			/* state flags */
        int start_no;		/* start number */
	int pic_no;			/* current pic number */
        int movie_no;           /* current movie number */
	int step;			/* number to use for increasing pic number */
        int time_per_frame; /* time per frame in milli secs */
	int max_frames;		/* max number of frames to record */
	float max_time;
	int compress;		/* for zlib and png */
	int quality;		/* needed for jpeg */
	char open_flags[8];
	int bpp;			/* for video4linux */
	int vid_dev;		/* file descriptor for video device */
	int snd_dev;		/* file descriptor for sound device */
	int snd_rate;
	int snd_smplsize;
	int snd_channels;
	int mouseWanted;	/* 0 none , 1 white , 2 black */
	char *video_dev;	/* video device */
	char *snd_device;	/* sound device */

	/* some function pointers
	 */
	void *(*get_colors)(XColor *, int);
	void *(*open)(char *, char *);
	int   (*write)(void *, unsigned int, unsigned int, void *);
	int   (*close)(void *);
	void  (*save)(FILE *, XImage *, struct _Job *);
	void  (*clean)(struct _Job *);
	Boolean  (*capture)(void *, unsigned long *);

	/* target format, e.g. CAP_XWD
	 */
	int target;
	int targetCodec;
	unsigned long crc;
	int ncolors;

	/* color table for the output file
	 */
	void *color_table;
	XColor *colors;
	XWindowAttributes win_attr;
//	Widget toplevel;
	XRectangle *area;
} Job;

/*
 * state flags
 */
#define VC_STOP		1
#define VC_START	2
#define VC_REC		4
#define VC_PAUSE	8
#define VC_STEP		16
#define VC_READY        32
#define VC_CONTINUE     64

/*
 * capture output formats
 */
#define CAP_XWD	1
#define CAP_PNM	2
#define CAP_PNG	3
#define CAP_MNG	4
#define CAP_JPG	5
#define CAP_QTR	6
#define CAP_QTJ	7
#define CAP_QTP	8
#define CAP_FFM 9
#define CAP_AVI	9
#define CAP_ASF 10
#define CAP_FLV 11

Job *job_init (int flags);
Job *job_ptr (void);
int  job_set_sound_dev (char *, int, int, int);
void  job_set_fps (float fps);
float job_fps (void);
void  job_set_file (char *file);
char *job_file (void);
void job_set_compression (int comp);
int  job_compression (void);
void job_set_shm (int shm);
void job_set_capture (void);
int  job_shm (void);
void job_set_quality (int quality);
int  job_quality (void);
void job_set_save_function (Visual *vis, int type, Job *jobp);
Boolean is_filename_mutable(char*);
#endif
