/*
 * video.h
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __VIDEO_H__
#define __VIDEO_H__

/* types */
#define VT_UNKNOWN	0
#define VT_AVI		1
#define VT_QT		2

#define VNI_VIDEO	1
#define VNI_SOUND	2

/* codecs */
#define VV_COD_RGB555	1
#define VV_COD_RGB565	2
#define VV_COD_RGB888	3

#define VS_COD_WAV_PCM	1
#define VS_COD_WAV_ALAW	6
#define VS_COD_WAV_MLAW	7


#define vid_swap2bytes(n) gv_swap2bytes(n)
#define vid_swap4bytes(n) gv_swap4bytes(n)

typedef struct {
	int type;		/* video type */
	int frames;		/* number of frames */
	int fps;		/* frames per second */
	int tpf;		/* time per frame in mili secs */
	int bps;		/* bytes per second */
	int width;
	int height;
	int size;
	int vid_no;
	int vid_depth;
	int vid_bpp;
	int vid_codec;
	int snd_codec;
	int snd_rate;
	int snd_size;	/* sample size */
	int snd_chnl;	/* sample size */
	int snd_no;
	int snd_buf_size;
	unsigned char *snd_buf;
	void *hdr;
	FILE *fp;		/* */
	FILE *fp_snd;	/* */
	/* */
	int out_pad;
	int out_codec;
	unsigned char *out_buf;
} video;

video *vid_open (char *);
void vid_close (video *);
void vid_reset (video *);
void vid_skip_frame (video *);
int vid_get_frame (video *, unsigned char *);
int vid_set_video_parms (video *vid, int codec, int pad);
void vid_skip_obj (video *);
int vid_next_in (video *);
int vid_get_sound (video *, unsigned char **, int *);

#define vid_snd_channels(v) 	v->snd_chnl
#define vid_snd_sample_rate(v)	v->snd_rate
#define vid_snd_sample_size(v)	v->snd_size
#define vid_snd_format(v)	v->snd_codec

#endif /* __VIDEO_H__ */

