 /* Dynamic allocation functions. */

static int append_message(struct tth_string *tth_msg,char *format,va_list ap) {
    char *new;
    int len,result;

#ifdef _GNU_SOURCE
    result=vasprintf(&new,format,ap);
#else
    new=(char*)malloc(MAX_BUFLENGTH);
    new[0]='\0';
    result=vsnprintf(new,MAX_BUFLENGTH,format,ap);
#endif /* _GNU_SOURCE */
    len=strlen(new);

#ifdef DYN_DEBUG
    fprintf(stderr,"before: len %d; gcount %d; max %d\n",
	    len,tth_msg->len,tth_msg->max);
#endif /* DYN_DEBUG */

    if (tth_msg->len+len < tth_maxlen) {
	if (tth_msg->len+len>tth_msg->max-2) {
	    tth_msg->max=(tth_msg->len+len)*2;
	    if (tth_msg->max>tth_maxlen) { tth_msg->max=tth_maxlen; }
	    if (tth_msg->max != 0) {
	      tth_msg->str=realloc(tth_msg->str,tth_msg->max);
	    } else {
	      return 1;
	    }
	    tth_msg->str[tth_msg->len]='\0';
	}
	strcat(tth_msg->str,new);
	tth_msg->len+=len;
    } else {
	if (tth_msg->max != tth_maxlen-1) { /*already maxed out or can 
					       we fit this one in?*/
	    tth_msg->max=tth_maxlen;
	    tth_msg->str=realloc(tth_msg->str,tth_msg->max);
	    tth_msg->str[tth_msg->len]='\0';
	    strncat(tth_msg->str,new,tth_msg->max-tth_msg->len-1);
	    tth_msg->len=strlen(tth_msg->str);
	}
    }
    free(new);

#ifdef DYN_DEBUG
    fprintf(stderr,"after: len %d; gcount %d; max %d; strlen(tth_msg): %d\n",
	    len,tth_msg->len,tth_msg->max,strlen(tth_msg->str));
#endif /* DYN_DEBUG */

    if (result==-1||result>MAX_BUFLENGTH) {
	return -1;
    } else {
	return 1;
    }
}

static void add_output(char *format, ...) {
    va_list ap;

    va_start(ap,format);
    if (append_message(&tth_out,format,ap)==-1)
	add_error("***Truncated last html chunk. Excessive length.\n");
}	

static void add_error(char *format, ...) {
    va_list ap;

    va_start(ap,format);
    if (append_message(&tth_err,format,ap)==-1)
	/* call append_message directly to avoid infinte loop*/
	append_message(&tth_err,"***Truncated last error message. Excessive length.\n",NULL);
}	

/* this assumes that the outputs have been freed by another function
   and that stale pointers are left in the str members.  This should
   be true, since the calling application is supposed to free the
   returned pointers
*/
void tth_init_outputs(){
    tth_out.len=0;
    tth_out.max=0;
    tth_out.str=NULL;
    tth_err.len=0;
    tth_err.max=0;
    tth_err.str=NULL;
}

/* this can be used to free up the str components if the output
   components are used internally, as in the reinit code 
*/
void tth_free_outputs(){
    if (tth_out.str) {free(tth_out.str);tth_out.str=NULL;}
    if (tth_err.str) {free(tth_err.str);tth_err.str=NULL;}
}

void tth_free_array(char* ar[],int num) {
  int i;
  for(i=0;i<num;i++) { if  ( ar[i] ) { free(ar[i]);ar[i]=NULL; } }  
}

 /* The function interface to tth. 
    Convert a texstring into an htmlstring which has length hlen.
  */

int textohtml(char* texstring, char* htmlstring, int hlen,
	      char* errstring, int elen)
{
  YY_BUFFER_STATE temp;
  /*  static int initialized=0;*/
  int returnval=0;
  if(tth_mathitalic){  /* Make italic the default.*/
    strcpy(tth_font_open[0],"<i>");
    strcpy(tth_font_close[0],"</i>");
    TTH_CCPY(tth_fonto_def,tth_font_open[0]);
    TTH_CCPY(tth_fontc_def,tth_font_close[0]);  
  }
  tth_init_outputs();
  tth_num_lines=0;
  if(!tth_initialized){
      /*yy_push_state(latexbuiltins); Uncomment to force always LaTeX.*/
    yy_push_state(builtins);
  }
  temp=yy_scan_string(texstring);
  returnval=yylex();
  yy_delete_buffer(temp);
  snprintf(htmlstring,hlen,tth_out.str);
  if (tth_out.len>hlen) { returnval |= 2; }
  snprintf(errstring,elen,tth_err.str);
  if (tth_err.len>elen) { returnval |= 4; }
  tth_free_outputs();
  if ( !tth_initialized ) {tth_initialized++;}
  return returnval;
}

 /*
  texttohtmldyn allocates memory dynamically for the output strings,
  however you can control it from consuming too much memory with the
  maxlen parameter.
 */
int textohtmldyn(char* texstring, char** htmlstring,
	      char** errstring, int maxlen)
{
  YY_BUFFER_STATE temp;
  int returnval=0;
  if(tth_mathitalic){  /* Make italic the default.*/
    strcpy(tth_font_open[0],"<i>");
    strcpy(tth_font_close[0],"</i>");
    TTH_CCPY(tth_fonto_def,tth_font_open[0]);
    TTH_CCPY(tth_fontc_def,tth_font_close[0]);  
  }
  tth_init_outputs();
  tth_num_lines=0;
  tth_maxlen=maxlen;
  if(!tth_initialized){
      /*yy_push_state(latexbuiltins); Uncomment to force always LaTeX.*/
    yy_push_state(builtins);
  }
  temp=yy_scan_string(texstring);
  returnval=yylex();
  yy_delete_buffer(temp); /* Normally deleted in yylex. This for errors.*/ 
  *htmlstring=tth_out.str;tth_out.str=NULL;
  *errstring=tth_err.str;tth_err.str=NULL;
  if ( !tth_initialized ) {tth_initialized++;}
  /*     if (tth_out.len==maxlen-1) { returnval |= 2; }
  if (tth_err.len==maxlen-1) { returnval |= 4; }
  return (returnval | tth_initialized);
  */
  return returnval;
}
void tth_restart () {
  /* Reset start conditions */
  yy_start_stack_ptr=0;
  if(yy_start_stack != NULL) {BEGIN(yy_start_stack[yy_start_stack_ptr]);}
  /* Reset counters etc */
  tth_reinitialize=1;
  yylex();
  tth_reinitialize=0;
}
