/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.treedisplay;

/**
 * An event that indicates that something important in a TreeDisplay
 * component has occurred. It is generated by TreeDisplay
 * widgets. Currently, the only event that can occur is a zoom event.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public class TreeDisplayEvent extends java.awt.AWTEvent {
	/** ID that indicates that a zoom has occurred. */
	public static final int ZOOM_PERFORMED = 0;

	/**
	 * Creates a new <code>TreeDisplayEvent</code> instance.
	 *
	 * @param source a <code>TreeDisplay</code> value
	 * @param id an <code>int</code> value
	 */
	public TreeDisplayEvent(TreeDisplay source, int id)
	{
		super(source, id);
	}
}// TreeDisplayEvent
