/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.stats;

import mx4j.MBeanDescriptionAdapter;

import java.lang.reflect.Method;
import java.lang.reflect.Constructor;

/**
 * Management interface descriptions for the ObserverStatisticsRecorder MBean.
 * @author <a href="mailto:tibu@users.sourceforge.net">Carlos Quiroz</a>
 * @version $Revision: 1.1 $
 */
public class ObserverStatisticsRecorderMBeanDescription extends StatisticsRecorderMBeanDescription
{
   public String getAttributeDescription(String attribute)
   {
      if (attribute.equals("ObservedAttribute"))
      {
         return "The Attribute to be observed";
      }
      if (attribute.equals("ObservedObject"))
      {
         return "The ObjectName to be observed";
      }
      return super.getAttributeDescription(attribute);
   }
}
