/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.stats;

import javax.management.ObjectName;

/**
 * Management interface for ObserverStatisticsRecorder MBeans.
 * @author <a href="mailto:tibu@users.sourceforge.net">Carlos Quiroz</a>
 * @version $Revision: 1.1 $
 */
public interface ObserverStatisticsRecorderMBean extends StatisticsRecorderMBean
{
   /**
    * Sets the ObjectName to be observed
    */
   public void setObservedObject(ObjectName object);

   /**
    * Returns the observed ObjectName
    */
   public ObjectName getObservedObject();

   /**
    * Returns the observed Attribute
    */
   public String getObservedAttribute();

   /**
    * Sets the Attribute to be observed
    */
   public void setObservedAttribute(String attribute);
}
