/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.heartbeat;
/**
 * Interface to be implemented by all modules that want to support
 * heartbeat mechanism.
 *
 * @author <a href="mailto:mgore@users.sourceforge.net">Michael Gorelik</a>
 * @version $Revision: 1.3 $
 */
public interface HeartBeatMBean
{
   // default HeartBeatMBean object name
   public static final String HEARTBEAT_OBJECT_NAME = "type=heartBeat";
   // connector types
   public static final String RMI_TYPE    = "rmi";
   public static final String IIOP_TYPE   = "iiop";
   // properties
   public static final String TRIES_PROP  = "mx4j.heartbeat.tries";
   public static final String PERIOD_PROP = "mx4j.heartbeat.period";
   // default heartbeat period in seconds
   public static final int DEFAULT_PERIOD = 10;
   /**
    * HeartBeat source will retry calling listener a few times and then will
    * declare listener down
    */
   public static final int DEFAULT_RETRIES = 3;
   /**
    * Adds the specified heartbeat listener to receive heartbeat notifications from
    * this HeartBeatMBean.
    */
   public void addHeartBeatListener(String heartBeatListenerName, Object connectorType, Object listenerAddress);
   /**
    * Removes the specified heartbeat listener so that it no longer receives
    * heartbeat notifications from this HeartBeatMBean.
    */
   public void removeHeartBeatListener(String heartBeatListenerName);
}
