/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector.rmi.jrmp;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;

import javax.management.NotificationFilter;

import mx4j.tools.connector.rmi.RemoteNotificationFilterSupport;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class JRMPRemoteNotificationFilterSupport extends RemoteNotificationFilterSupport
{
	public JRMPRemoteNotificationFilterSupport(NotificationFilter clientFilter)
	{
		super(clientFilter);
	}

	public void export() throws RemoteException
	{
		UnicastRemoteObject.exportObject(getRemoteNotificationFilter());
	}

	public void export(int port) throws RemoteException
	{
		UnicastRemoteObject.exportObject(getRemoteNotificationFilter(), port);
	}

	public void export(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException
	{
		UnicastRemoteObject.exportObject(getRemoteNotificationFilter(), port, csf, ssf);
	}

	public void unexport() throws NoSuchObjectException
	{
		UnicastRemoteObject.unexportObject(getRemoteNotificationFilter(), true);
	}
}
