/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector.rmi;

import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;

import javax.management.Notification;
import javax.management.NotificationListener;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
class RemoteNotificationListenerImpl extends RemoteObject implements RemoteNotificationListener
{
	private NotificationListener m_realListener;

	RemoteNotificationListenerImpl(NotificationListener realListener)
	{
		m_realListener = realListener;
	}

	public void handleNotification(Notification notification, Object handback) throws RemoteException
	{
		// We are on the client

		// Unwrap the handback, and forward to the real listener
		Object realHandback = null;
		if (handback instanceof MarshalledObject)
		{
			try
			{
				realHandback = ((MarshalledObject)handback).get();
			}
			catch (Exception x)
			{
				// No exception should happen, since I was able to marshal it, I must be able to unmarshal it
				x.printStackTrace();
			}
		}
		else
		{
			realHandback = handback;
		}

		m_realListener.handleNotification(notification, realHandback);
	}
}
