/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.log;

import javax.management.NotificationListener;
import javax.management.NotificationFilter;
import javax.management.ListenerNotFoundException;

/**
 * Management interface for the LoggerBroadcaster MBean.
 *
 * @see LoggerBroadcaster
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.3 $
 */
public interface LoggerBroadcasterMBean
{
	public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback);
	public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException;
	public void start();
	public void start(String category);
	public void stop();
	public void stop(String category);
}
