/**
 * ========================================
 * JFreeReport : a free Java report library
 * ========================================
 *
 * Project Info:  http://www.object-refinery.com/jfreereport/index.html
 * Project Lead:  Thomas Morgner (taquera@sherito.org);
 *
 * (C) Copyright 2000-2003, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ------------------------------
 * ObjectFactoryTest.java
 * ------------------------------
 * (C)opyright 2003, by Thomas Morgner and Contributors.
 *
 * Original Author:  Thomas Morgner;
 * Contributor(s):   David Gilbert (for Simba Management Limited);
 *
 * $Id: ObjectFactoryTest.java,v 1.1 2003/06/11 20:44:33 taqua Exp $
 *
 * Changes
 * -------------------------
 * 04.06.2003 : Initial version
 *
 */

package com.jrefinery.report.ext.junit.base.basic.io.ext;

import java.awt.geom.Line2D;

import com.jrefinery.report.io.ext.factory.objects.DefaultClassFactory;
import junit.framework.TestCase;
import org.jfree.xml.factory.objects.ObjectDescription;

public class ObjectFactoryTest extends TestCase
{
  public ObjectFactoryTest(String s)
  {
    super(s);
  }

  public void testObjectQuery()
  {
    DefaultClassFactory fact = new DefaultClassFactory();
    ObjectDescription line2DDescr = fact.getDescriptionForClass(Line2D.class);
    assertNotNull(line2DDescr);
    ObjectDescription od = fact.getSuperClassObjectDescription(Line2D.Float.class, null);
    assertEquals(line2DDescr.getClass(), od.getClass());
  }
}
