/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.remoting.transport.multiplex.config;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.HashMap;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.multiplex.Multiplex;
import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;

/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision$
 * <p>
 * Copyright (c) May 19, 2006
 * </p>
 */
public class ClientConfigurationCallbackConnectorTestClient extends ClientConfigurationTestClient
{
   public void testConfigurationByMap()
   {
      log.info("entering " + getName());
      
      try
      {
         // Create HashMap with parameters.
         HashMap conf = new HashMap();
         conf.put(Multiplex.MULTIPLEX_CONNECT_HOST,
                  ClientConfigurationTestServer.connectorHost);
         conf.put(Multiplex.MULTIPLEX_CONNECT_PORT,
                  new Integer(ClientConfigurationTestServer.connectorPort));
         conf.put(Multiplex.SERVER_MULTIPLEX_ID, "id1");
         conf.put(Multiplex.MAX_ACCEPT_ERRORS, new Integer(2 + Multiplex.MAX_ACCEPT_ERRORS_DEFAULT));
         
         // Create callback Connector.
         Connector connector = new Connector("multiplex://localhost", conf);
         connector.create();
         connector.start();
         
         // Test parameters.
         MultiplexServerInvoker invoker = (MultiplexServerInvoker) connector.getServerInvoker();
         Field field = MultiplexServerInvoker.class.getDeclaredField("socketGroupInfo");
         field.setAccessible(true);
         MultiplexServerInvoker.SocketGroupInfo sgi = (MultiplexServerInvoker.SocketGroupInfo) field.get(invoker);
 
         field = MultiplexServerInvoker.class.getDeclaredField("multiplexConnectHost");
         field.setAccessible(true);
         assertEquals((String)field.get(invoker), ClientConfigurationTestServer.connectorHost);
        
         field = MultiplexServerInvoker.class.getDeclaredField("multiplexConnectPort");
         field.setAccessible(true);
         assertEquals(field.getInt(invoker), ClientConfigurationTestServer.connectorPort);
         assertEquals(sgi.getConnectPort(), ClientConfigurationTestServer.connectorPort);
         
         field = MultiplexServerInvoker.class.getDeclaredField("serverMultiplexId");
         field.setAccessible(true);
         assertEquals((String)field.get(invoker), "id1");
         assertEquals(sgi.getSocketGroupId(), "id1");
         
         field = MultiplexServerInvoker.class.getDeclaredField("maxAcceptErrors");
         field.setAccessible(true);
         assertEquals(field.getInt(invoker), 2 + Multiplex.MAX_ACCEPT_ERRORS_DEFAULT);
         
         assertEquals(sgi.getConnectAddress().getHostName(), ClientConfigurationTestServer.connectorHost);
         
         connector.stop();
         log.info(getName() + ": PASSES");
      }
      catch (Exception e)
      {
         log.error(e);
         e.printStackTrace();
         fail();
         log.info(getName() + ": FAILS");
      }
   }
   
   
   public void testConfigurationByMapThenByInvokerSetter()
   {
      log.info("entering " + getName());
      
      try
      {
         // Create HashMap with parameters.
         HashMap conf = new HashMap();
         conf.put(Multiplex.MULTIPLEX_CONNECT_HOST,
                  ClientConfigurationTestServer.connectorHost);
         conf.put(Multiplex.MULTIPLEX_CONNECT_PORT,
                  new Integer(ClientConfigurationTestServer.connectorPort));
         conf.put(Multiplex.SERVER_MULTIPLEX_ID, "id1");
         conf.put(Multiplex.MAX_ACCEPT_ERRORS, new Integer(2 + Multiplex.MAX_ACCEPT_ERRORS_DEFAULT));
         
         // Create callback Connector.
         Connector connector = new Connector("multiplex://localhost", conf);
         connector.create();
         connector.start();
         
         // Test parameters.
         MultiplexServerInvoker invoker = (MultiplexServerInvoker) connector.getServerInvoker();
         Field field = MultiplexServerInvoker.class.getDeclaredField("socketGroupInfo");
         field.setAccessible(true);
         MultiplexServerInvoker.SocketGroupInfo sgi = (MultiplexServerInvoker.SocketGroupInfo) field.get(invoker);
 
         field = MultiplexServerInvoker.class.getDeclaredField("multiplexConnectHost");
         field.setAccessible(true);
         assertEquals((String)field.get(invoker), ClientConfigurationTestServer.connectorHost);
         assertEquals(sgi.getConnectAddress().getHostName(), ClientConfigurationTestServer.connectorHost);
          
         field = MultiplexServerInvoker.class.getDeclaredField("multiplexConnectPort");
         field.setAccessible(true);
         assertEquals(field.getInt(invoker), ClientConfigurationTestServer.connectorPort);
         assertEquals(sgi.getConnectPort(), ClientConfigurationTestServer.connectorPort);
         
         field = MultiplexServerInvoker.class.getDeclaredField("serverMultiplexId");
         field.setAccessible(true);
         assertEquals((String)field.get(invoker), "id1");
         assertEquals(sgi.getSocketGroupId(), "id1");
         
         field = MultiplexServerInvoker.class.getDeclaredField("maxAcceptErrors");
         field.setAccessible(true);
         assertEquals(field.getInt(invoker), 2 + Multiplex.MAX_ACCEPT_ERRORS_DEFAULT);
         
         connector.stop();
         log.info(getName() + ": PASSES");
      }
      catch (Exception e)
      {
         log.error(e);
         e.printStackTrace();
         fail();
         log.info(getName() + ": FAILS");
      }
      
      log.info(getName() + ": PASSED");
   }
   
   
   
   public void testBogusInvokerGroupParameters()
   {
      log.info("entering " + getName());
      
      try
      {
         // Create HashMap with parameters.
         HashMap conf = new HashMap();
         conf.put(Multiplex.SERVER_MULTIPLEX_ID, "id2");
         
         // Create callback Connector.
         Connector connector = new Connector("multiplex://localhost", conf);
         connector.create();
         connector.start();
         
         // Create Client, which will lead to the creation of priming socket.
         String locatorURI = ClientConfigurationTestServer.connectorURI + "/?clientMultiplexId=id2";
         InvokerLocator locator = new InvokerLocator(locatorURI);
         Client client = new Client(locator);
         client.connect();
         
         // Test parameters.
         MultiplexServerInvoker invoker = (MultiplexServerInvoker) connector.getServerInvoker();
         Field field = MultiplexServerInvoker.class.getDeclaredField("socketGroupInfo");
         field.setAccessible(true);
         MultiplexServerInvoker.SocketGroupInfo sgi = (MultiplexServerInvoker.SocketGroupInfo) field.get(invoker);
 
         field = MultiplexServerInvoker.class.getDeclaredField("multiplexConnectHost");
         field.setAccessible(true);
         InetAddress connectAddress = InetAddress.getByName(ClientConfigurationTestServer.connectorHost);
         assertEquals(sgi.getConnectAddress(), connectAddress);
          
         field = MultiplexServerInvoker.class.getDeclaredField("multiplexConnectPort");
         field.setAccessible(true);
         assertEquals(sgi.getConnectPort(), ClientConfigurationTestServer.connectorPort);
         
         field = MultiplexServerInvoker.class.getDeclaredField("serverMultiplexId");
         field.setAccessible(true);
         assertEquals((String)field.get(invoker), "id2");
         assertEquals(sgi.getSocketGroupId(), "id2");

         client.disconnect();
         connector.stop();
         log.info(getName() + ": PASSES");
      }
      catch (Exception e)
      {
         log.error(e);
         e.printStackTrace();
         fail();
         log.info(getName() + ": FAILS");
      }
      
      log.info(getName() + ": PASSED");
   }
   
   public void testConclusion()
   {
      try
      {
         if (os != null)
            os.write(3);
         if (syncSocket != null)
            syncSocket.close();
      }
      catch (IOException e)
      {
         log.error(e);
         e.printStackTrace();
      }
   }
}
