/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.remoting.lease;

import java.lang.reflect.Field;
import java.util.TimerTask;

import junit.framework.TestCase;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.LeasePinger;
import org.jboss.remoting.transport.socket.SocketClientInvoker;


/**
 * Unit test for JBREM-794.
 * 
 * @author <a href="ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision: 2685 $
 * <p>
 * Copyright Aug 22, 2007
 * </p>
 */
public class UniquePingerTaskTestCase extends TestCase
{
   private static Logger log = Logger.getLogger(UniquePingerTaskTestCase.class);
   private static boolean firstTime = true;

   
   /**
    * Sets up target remoting server.
    */
   public void setUp() throws Exception
   {
      if (firstTime)
      {
         firstTime = false;
         Logger.getLogger("org.jboss.remoting").setLevel(Level.INFO);
         Logger.getLogger("org.jboss.test.remoting").setLevel(Level.INFO);
         String pattern = "[%d{ABSOLUTE}] [%t] %5p (%F:%L) - %m%n";
         PatternLayout layout = new PatternLayout(pattern);
         ConsoleAppender consoleAppender = new ConsoleAppender(layout);
         Logger.getRootLogger().addAppender(consoleAppender);  
      }
   }

   
   public void tearDown()
   {
   }
   
   
   /**
    * Verifies that only one LeasePinger.LeaseTimerTask gets created.
    */
   public void testUniqueLeaseTimerTask() throws Throwable
   {
      log.info("entering " + getName());
      
      InvokerLocator locator = new InvokerLocator("socket://localhost:8888");
      SocketClientInvoker clientInvoker = new SocketClientInvoker(locator);
      LeasePinger leasePinger = new LeasePinger(clientInvoker, "abc", 2000);
      log.info("expect WARN \"failed to ping to server\"");
      leasePinger.addClient("def", null, 1000);
      
      // Verify LeasePingerTimerTask has not been created.
      Field field = LeasePinger.class.getDeclaredField("timerTask");
      field.setAccessible(true);
      TimerTask timerTask = (TimerTask) field.get(leasePinger);
      assertNull(timerTask);
      leasePinger.startPing();
      timerTask = (TimerTask) field.get(leasePinger);
      assertNotNull(timerTask);
      
      // Verify new LeasePingerTimerTask gets created when adding new Client
      // with shorter lease period.
      leasePinger.addClient("ghi", null, 500);
      TimerTask newTimerTask = (TimerTask) field.get(leasePinger);
      assertNotSame(newTimerTask, timerTask);
      
      log.info(getName() + " PASSES");
   }
}