package org.jboss.test.remoting.transport.socket.timeout.idle;

import java.net.ServerSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.io.IOException;
import java.io.BufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class UnblockReadTest extends Thread
{
   protected int serverBindPort = 6700;
   protected int backlog = 200;
   protected ServerSocket serverSocket;
   protected InetAddress bindAddress;
   protected String serverBindAddress = "localhost";
   protected int timeout = 60000; // 60 seconds.

   public UnblockReadTest()
   {
      try
      {
         bindAddress = InetAddress.getByName(serverBindAddress);
         serverSocket = new ServerSocket(serverBindPort, backlog, bindAddress);
      }
      catch(IOException e)
      {
         e.printStackTrace();
      }
   }

   /**
    * When an object implementing interface <code>Runnable</code> is used
    * to create a thread, starting the thread causes the object's
    * <code>run</code> method to be called in that separately executing
    * thread.
    * <p/>
    * The general contract of the method <code>run</code> is that it may
    * take any action whatsoever.
    *
    * @see Thread#run()
    */
   public void run()
   {
      try
      {
         Socket socket = serverSocket.accept();
         socket.setSoTimeout(timeout);

         BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
//         OptimizedObjectOutputStream out = new OptimizedObjectOutputStream(bos);
//         out.flush();
         BufferedInputStream bis = new BufferedInputStream(socket.getInputStream());
//         OptimizedObjectInputStream in = new OptimizedObjectInputStream(bis);

         ObjectOutputStream oos = new ObjectOutputStream(bos);
         oos.flush();
         ObjectInputStream objInputStream = new ObjectInputStream(bis);


         processRequest(objInputStream, oos);

         while(true)
         {
            acknowledge(objInputStream, oos);
            processRequest(objInputStream, oos);
         }


      }
      catch(IOException e)
      {
         e.printStackTrace();
      }
      catch(ClassNotFoundException e)
      {
         e.printStackTrace();
      }
   }

   private void processRequest(ObjectInputStream objInputStream, ObjectOutputStream oos)
         throws IOException, ClassNotFoundException
   {
      Object obj = objInputStream.readObject();
      objInputStream.readObject();

//         Object obj = in.readObject();
//         in.readObject(); // for stupid ObjectInputStream reset

      System.out.println("Object read: " + obj);

      Object resp = null;
      try
      {
         // Make absolutely sure thread interrupted is cleared.
         boolean interrupted = Thread.interrupted();
         // call transport on the subclass, get the result to handback
         resp = "This is response.";
      }
      catch(Exception ex)
      {
         resp = ex;
      }

      Thread.interrupted(); // clear interrupted state so we don't fail on socket writes


      oos.writeObject(resp);

      //oos.flush();

      oos.reset();
      // to make sure stream gets reset
      // Stupid ObjectInputStream holds object graph
      // can only be set by the client/server sending a TC_RESET
      oos.writeObject(Boolean.TRUE);
      oos.flush();
      oos.reset();
   }

   private void acknowledge(ObjectInputStream objInputStream, ObjectOutputStream oos) throws IOException
   {
      // now stay open and wait for ack
      System.out.println("waiting for ack");
      byte ACK = objInputStream.readByte();
      System.out.println("got ack");
      oos.writeByte(ACK);
      oos.flush();
      oos.reset();

   }

   public static void main(String[] args)
   {
      try
      {
         UnblockReadTest server = new UnblockReadTest();
         server.start();

         Thread.currentThread().sleep(30000);

         server.interrupt();
      }
      catch (InterruptedException e)
      {
         e.printStackTrace();
      }
   }
}