/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.remoting.transport.multiplex.config;

import java.io.InputStream;
import java.net.Socket;

import org.jboss.jrunit.extensions.ServerTestCase;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;


/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision$
 * <p>
 * Copyright (c) May 19, 2006
 * </p>
 */
public class ConfigurationTestServer extends ServerTestCase
{
   public static final String syncHost      = "localhost";
   public static final int    syncPort      = 3245;
   public static final String connectorURI1 = "multiplex://localhost:3246";
   public static final String connectorURI2 = "multiplex://localhost:3247";
   public static final String connectorURI3 = "multiplex://localhost:3248";
   public static final String connectorURI4 = "multiplex://localhost:3249";
   public static final String connectorURI5 = "multiplex://localhost:3250";
   public static final String connectorURI6 = "multiplex://localhost:3251";
   public static final String connector6BindHost = "localhost";
   public static final int    connector6BindPort = 3251;
   
   protected static final Logger log = Logger.getLogger(ConfigurationTestServer.class);
   protected Socket syncSocket;
   protected InputStream is;
   
   public void setUp()
   {
      new Thread()
      {
         public void run()
         {
            try
            {
               while (true)
               {
                  try
                  {
                     syncSocket = new Socket(syncHost, syncPort);
                     break;
                  }
                  catch (Exception e)
                  {
                     Thread.sleep(1000);
                     log.info(e);
                  }
               }
               
               log.info("synchronized socket created");
               is = syncSocket.getInputStream();
               runTest();
            }
            catch (Exception e)
            {
               log.error(e);
               e.printStackTrace();
            }     
         }
      }.start();
   }
   
   
   protected void runTest() throws Exception
   {
   }
   
   
   protected class Th extends Thread
   {
      private String uri;
      private String id;
      public Th(String uri, String id) {this.uri = uri; this.id = id;} 
      public void run()
      {
         try
         {
            log.info("connecting to: " + uri);
            Client client = new Client(new InvokerLocator(uri));
            client.connect();
            synchronized (this)
            {
               wait();
            }
            client.disconnect();
         }
         catch (Exception e)
         {
            log.error(id, e);
            e.printStackTrace();
         }
      }
   }
   
   
   public static void main(String[] args)
   {
      ConfigurationTestServer tester = new ConfigurationTestServer();
      tester.setUp();
   }
}