package org.jboss.test.remoting.transport.bisocket.ssl.timeout;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;

import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.transport.socket.MicroSocketClientInvoker;
import org.jboss.remoting.transport.socket.SocketWrapper;
import org.jboss.test.remoting.transport.socket.ssl.timeout.SSLSocketPerInvocationTimeoutTestCase;

/**
 * See javadoc for PerInvocationTimeoutTestRoot.
 *  
 * @author <a href="ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision: 1.1.2.2 $
 * <p>
 * Copyright Feb 6, 2007
 * </p>
 */
public class SSLBisocketPerInvocationTimeoutTestCase extends SSLSocketPerInvocationTimeoutTestCase
{
   /**
    * This test verifies that the timeout for a socket wrapper gets reset after
    * an invocation with an invocation specific timeout has been executed.
    */
   public void testTimeoutReset() throws Throwable
   {
      log.info("entering " + getName());
      ClientInvoker invoker = client.getInvoker();
      assertTrue(invoker instanceof MicroSocketClientInvoker);
      Field field = MicroSocketClientInvoker.class.getDeclaredField("pool");
      field.setAccessible(true);
      List pool = (List) field.get(invoker);
      // Note that an invoker is created during the connect phase.
      assertEquals(1, pool.size());
      
      Object response = client.invoke(NO_WAIT);
      assertEquals(NO_WAIT, response);
      assertEquals(1, pool.size());
      SocketWrapper socket = (SocketWrapper) pool.get(0);
      assertEquals(CONFIGURED_TIMEOUT, socket.getTimeout());
      
      HashMap metadata = new HashMap();
      metadata.put(ServerInvoker.TIMEOUT, "1000");
      response = client.invoke(NO_WAIT, metadata);
      assertEquals(NO_WAIT, response);
      assertEquals(1, pool.size());
      socket = (SocketWrapper) pool.get(0);
      assertEquals(CONFIGURED_TIMEOUT, socket.getTimeout());
   }
   
   protected String getTransport()
   {
      return "sslbisocket";
   }
}
